/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beans;

import com.hotels.beans.conversion.Converter;
import com.hotels.beans.conversion.ConverterImpl;
import com.hotels.beans.transformer.BeanTransformer;
import com.hotels.beans.transformer.TransformerImpl;
import com.hotels.transformer.validator.Validator;
import com.hotels.transformer.validator.ValidatorImpl;
import java.util.function.Function;

public class BeanUtils {
    public static <T, K> Function<T, K> getTransformer(Class<K> targetClass) {
        return fromBean -> new TransformerImpl().transform(fromBean, targetClass);
    }

    public static <T, K> Function<T, K> getTransformer(BeanTransformer beanTransformer, Class<K> targetClass) {
        Validator.notNull((Object)beanTransformer, (String)"beanTransformer cannot be null!");
        return fromBean -> beanTransformer.transform(fromBean, targetClass);
    }

    public final BeanTransformer getTransformer() {
        return new TransformerImpl();
    }

    public final Validator getValidator() {
        return new ValidatorImpl();
    }

    public final Converter getPrimitiveTypeConverter() {
        return new ConverterImpl();
    }
}

