/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beans.populator;

import com.hotels.beans.populator.ArrayPopulator;
import com.hotels.beans.populator.CollectionPopulator;
import com.hotels.beans.populator.MapPopulator;
import com.hotels.beans.populator.OptionalPopulator;
import com.hotels.beans.populator.Populator;
import com.hotels.beans.transformer.BeanTransformer;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public final class PopulatorFactory {
    public static <O, T> Optional<Populator> getPopulator(Class<O> destObjectClass, Class<T> sourceObjectClass, BeanTransformer transformer) {
        Optional<Populator> populator = Optional.empty();
        if (destObjectClass.isArray()) {
            populator = Optional.of(new ArrayPopulator(transformer));
        } else if (Collection.class.isAssignableFrom(destObjectClass)) {
            populator = Optional.of(new CollectionPopulator(transformer));
        } else if (Map.class.isAssignableFrom(destObjectClass)) {
            populator = Optional.of(new MapPopulator(transformer));
        } else if (Optional.class == sourceObjectClass || Optional.class == destObjectClass) {
            populator = Optional.of(new OptionalPopulator(transformer));
        }
        return populator;
    }

    private PopulatorFactory() {
    }
}

