/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beans.transformer;

import com.hotels.beans.conversion.analyzer.ConversionAnalyzer;
import com.hotels.beans.transformer.BeanTransformer;
import com.hotels.beans.transformer.Transformer;
import com.hotels.beans.transformer.TransformerSettings;
import com.hotels.transformer.cache.CacheManager;
import com.hotels.transformer.cache.CacheManagerFactory;
import com.hotels.transformer.model.FieldMapping;
import com.hotels.transformer.model.FieldTransformer;
import com.hotels.transformer.utils.ClassUtils;
import com.hotels.transformer.utils.ReflectionUtils;
import com.hotels.transformer.validator.Validator;
import com.hotels.transformer.validator.ValidatorImpl;
import java.util.Arrays;
import java.util.Map;

abstract class AbstractTransformer
implements BeanTransformer {
    static final String TRANSFORMER_FUNCTION_CACHE_PREFIX = "TransformerFunction";
    private static final String TRANSFORMER_FUNCTION_REGEX = "^TransformerFunction.*";
    final ReflectionUtils reflectionUtils = new ReflectionUtils();
    final ClassUtils classUtils = new ClassUtils();
    final CacheManager cacheManager;
    final TransformerSettings settings = new TransformerSettings();
    Validator validator;
    ConversionAnalyzer conversionAnalyzer;

    AbstractTransformer() {
        this.cacheManager = CacheManagerFactory.getCacheManager((String)"transformer");
    }

    @Override
    public final BeanTransformer withFieldMapping(FieldMapping ... fieldMapping) {
        Map<String, String> fieldsNameMapping = this.settings.getFieldsNameMapping();
        for (FieldMapping mapping : fieldMapping) {
            fieldsNameMapping.put(mapping.getDestFieldName(), mapping.getSourceFieldName());
        }
        return this;
    }

    @Override
    @Deprecated
    public final Transformer withFieldMapping(com.hotels.beans.model.FieldMapping ... fieldMapping) {
        Map<String, String> fieldsNameMapping = this.settings.getFieldsNameMapping();
        for (com.hotels.beans.model.FieldMapping mapping : fieldMapping) {
            fieldsNameMapping.put(mapping.getDestFieldName(), mapping.getSourceFieldName());
        }
        return this;
    }

    @Override
    public final void removeFieldMapping(String destFieldName) {
        Validator.notNull((Object)destFieldName, (String)"The field name for which the mapping has to be removed cannot be null!");
        this.settings.getFieldsNameMapping().remove(destFieldName);
    }

    @Override
    public final void resetFieldsMapping() {
        this.settings.getFieldsNameMapping().clear();
    }

    @Override
    public final BeanTransformer withFieldTransformer(FieldTransformer ... fieldTransformer) {
        Map<String, FieldTransformer> fieldsTransformers = this.settings.getFieldsTransformers();
        for (FieldTransformer transformer : fieldTransformer) {
            fieldsTransformers.put(transformer.getDestFieldName(), transformer);
        }
        return this;
    }

    @Override
    @Deprecated
    public final Transformer withFieldTransformer(com.hotels.beans.model.FieldTransformer ... fieldTransformer) {
        Map<String, FieldTransformer> fieldsTransformers = this.settings.getFieldsTransformers();
        for (com.hotels.beans.model.FieldTransformer transformer : fieldTransformer) {
            fieldsTransformers.put(transformer.getDestFieldName(), transformer);
        }
        return this;
    }

    @Override
    public final void removeFieldTransformer(String destFieldName) {
        Validator.notNull((Object)destFieldName, (String)"The field name for which the transformer function has to be removed cannot be null!");
        this.settings.getFieldsTransformers().remove(destFieldName);
        this.cacheManager.removeMatchingKeys(TRANSFORMER_FUNCTION_REGEX + destFieldName);
    }

    @Override
    public final void resetFieldsTransformer() {
        this.settings.getFieldsTransformers().clear();
        this.cacheManager.removeMatchingKeys(TRANSFORMER_FUNCTION_REGEX);
    }

    @Override
    public final BeanTransformer setDefaultValueForMissingField(boolean useDefaultValue) {
        this.settings.setSetDefaultValueForMissingField(useDefaultValue);
        return this;
    }

    @Override
    public final BeanTransformer setFlatFieldNameTransformation(boolean useFlatTransformation) {
        this.settings.setFlatFieldNameTransformation(useFlatTransformation);
        return this;
    }

    @Override
    public BeanTransformer setValidationEnabled(boolean validationEnabled) {
        this.settings.setValidationEnabled(validationEnabled);
        if (validationEnabled) {
            this.validator = new ValidatorImpl();
        }
        return this;
    }

    @Override
    public BeanTransformer setDefaultValueSetEnabled(boolean defaultValueSetEnabled) {
        this.settings.setDefaultValueSetEnabled(defaultValueSetEnabled);
        return this;
    }

    @Override
    public BeanTransformer setPrimitiveTypeConversionEnabled(boolean primitiveTypeConversionEnabled) {
        this.settings.setPrimitiveTypeConversionEnabled(primitiveTypeConversionEnabled);
        if (primitiveTypeConversionEnabled) {
            this.conversionAnalyzer = new ConversionAnalyzer();
        } else {
            this.cacheManager.removeMatchingKeys(TRANSFORMER_FUNCTION_REGEX);
        }
        return this;
    }

    public final <T, K> K transform(T sourceObj, Class<? extends K> targetClass) {
        Validator.notNull(sourceObj, (String)"The object to copy cannot be null!");
        Validator.notNull(targetClass, (String)"The destination class cannot be null!");
        return this.transform(sourceObj, targetClass, (String)null);
    }

    protected abstract <T, K> K transform(T var1, Class<? extends K> var2, String var3);

    public final <T, K> void transform(T sourceObj, K targetObject) {
        Validator.notNull(sourceObj, (String)"The object to copy cannot be null!");
        Validator.notNull(targetObject, (String)"The destination object cannot be null!");
        this.transform(sourceObj, targetObject, null);
    }

    @Override
    public BeanTransformer skipTransformationForField(String ... fieldName) {
        if (fieldName.length != 0) {
            this.settings.getFieldsToSkip().addAll(Arrays.asList(fieldName));
        }
        return this;
    }

    @Override
    public void resetFieldsTransformationSkip() {
        this.settings.getFieldsToSkip().clear();
    }

    protected abstract <T, K> void transform(T var1, K var2, String var3);
}

