/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beans.transformer;

import com.hotels.beans.populator.PopulatorFactory;
import com.hotels.beans.transformer.AbstractTransformer;
import com.hotels.transformer.annotation.ConstructorArg;
import com.hotels.transformer.base.Defaults;
import com.hotels.transformer.constant.ClassType;
import com.hotels.transformer.constant.Punctuation;
import com.hotels.transformer.error.InvalidBeanException;
import com.hotels.transformer.error.MissingFieldException;
import com.hotels.transformer.model.FieldTransformer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;

public class TransformerImpl
extends AbstractTransformer {
    @Override
    protected final <T, K> K transform(T sourceObj, Class<? extends K> targetClass, String breadcrumb) {
        Object k;
        ClassType classType = this.classUtils.getClassType(targetClass);
        if (classType.is(ClassType.MUTABLE)) {
            try {
                k = this.classUtils.getInstance(this.classUtils.getNoArgsConstructor(targetClass), new Object[0]);
                this.injectAllFields(sourceObj, k, breadcrumb);
            }
            catch (Exception e) {
                throw new InvalidBeanException(e.getMessage(), (Throwable)e);
            }
        } else {
            k = this.injectValues(sourceObj, targetClass, this.classUtils.getAllArgsConstructor(targetClass), breadcrumb);
            if (classType.is(ClassType.MIXED)) {
                this.injectNotFinalFields(sourceObj, k, breadcrumb);
            }
        }
        if (this.settings.isValidationEnabled()) {
            this.validator.validate(k);
        }
        return k;
    }

    @Override
    protected final <T, K> void transform(T sourceObj, K targetObject, String breadcrumb) {
        this.injectAllFields(sourceObj, targetObject, breadcrumb);
        if (this.settings.isValidationEnabled()) {
            this.validator.validate(targetObject);
        }
    }

    private <T, K> K injectValues(T sourceObj, Class<K> targetClass, Constructor constructor, String breadcrumb) {
        Object[] constructorArgs = this.canBeInjectedByConstructorParams(constructor, targetClass) ? this.getConstructorArgsValues(sourceObj, targetClass, constructor, breadcrumb) : this.getConstructorValuesFromFields(sourceObj, targetClass, breadcrumb);
        try {
            return (K)this.classUtils.getInstance(constructor, constructorArgs);
        }
        catch (Exception e) {
            throw new InvalidBeanException("Constructor invoked with arguments. Expected: " + constructor + "; Found: " + this.getFormattedConstructorArgs(targetClass, constructorArgs) + ". Double check that each " + targetClass.getSimpleName() + "'s field have the same type and name than the source object: " + sourceObj.getClass().getName() + " otherwise specify a transformer configuration. Error message: " + e.getMessage(), (Throwable)e);
        }
    }

    private <K> String getFormattedConstructorArgs(Class<K> targetClass, Object[] constructorArgs) {
        return Arrays.stream(constructorArgs).map(arg -> Objects.isNull(arg) ? "null" : arg.getClass().getName()).collect(Collectors.joining(Punctuation.COMMA.getSymbol(), targetClass.getName() + Punctuation.LPAREN.getSymbol(), Punctuation.RPAREN.getSymbol()));
    }

    private <K> boolean canBeInjectedByConstructorParams(Constructor constructor, Class<K> targetClass) {
        String cacheKey = "CanBeInjectedByConstructorParams-" + constructor.getDeclaringClass().getName();
        return this.cacheManager.getFromCache(cacheKey, Boolean.class).orElseGet(() -> {
            boolean res = this.classUtils.getPrivateFinalFields(targetClass).size() == constructor.getParameterCount() && (this.classUtils.areParameterNamesAvailable(constructor) || this.classUtils.allParameterAnnotatedWith(constructor, ConstructorArg.class));
            this.cacheManager.cacheObject(cacheKey, (Object)res);
            return res;
        });
    }

    private <T, K> Object[] getConstructorArgsValues(T sourceObj, Class<K> targetClass, Constructor constructor, String breadcrumb) {
        Parameter[] constructorParameters = this.classUtils.getConstructorParameters(constructor);
        Object[] constructorArgsValues = new Object[constructorParameters.length];
        IntStream.range(0, constructorParameters.length).forEach(i -> {
            String destFieldName = this.getDestFieldName(constructorParameters[i], targetClass.getName());
            if (Objects.isNull(destFieldName)) {
                constructorArgsValues[i] = this.classUtils.getDefaultTypeValue(constructorParameters[i].getType());
            } else {
                String sourceFieldName = this.getSourceFieldName(destFieldName);
                constructorArgsValues[i] = this.getFieldValue(sourceObj, sourceFieldName, targetClass, this.reflectionUtils.getDeclaredField(destFieldName, targetClass), breadcrumb);
            }
        });
        return constructorArgsValues;
    }

    private boolean doSkipTransformation(String breadcrumb) {
        return this.settings.getFieldsToSkip().contains(breadcrumb);
    }

    private String getSourceFieldName(Field field) {
        return this.getSourceFieldName(field.getName());
    }

    private String getSourceFieldName(String fieldName) {
        return Optional.ofNullable(this.settings.getFieldsNameMapping().get(fieldName)).orElse(fieldName);
    }

    private String getDestFieldName(Parameter constructorParameter, String declaringClassName) {
        String cacheKey = "DestFieldName-" + declaringClassName + "-" + constructorParameter.getName();
        return this.cacheManager.getFromCache(cacheKey, String.class).orElseGet(() -> {
            String destFieldName = constructorParameter.isNamePresent() ? constructorParameter.getName() : (String)Optional.ofNullable(this.reflectionUtils.getParameterAnnotation(constructorParameter, ConstructorArg.class, declaringClassName)).map(ConstructorArg::value).orElse(null);
            this.cacheManager.cacheObject(cacheKey, (Object)destFieldName);
            return destFieldName;
        });
    }

    private <T, K> Object[] getConstructorValuesFromFields(T sourceObj, Class<K> targetClass, String breadcrumb) {
        List declaredFields = this.classUtils.getDeclaredFields(targetClass, true);
        return declaredFields.stream().map(field -> this.getFieldValue(sourceObj, targetClass, (Field)field, breadcrumb)).toArray(Object[]::new);
    }

    private <T, K> void injectAllFields(T sourceObj, K targetObject, String breadcrumb) {
        Class<?> targetObjectClass = targetObject.getClass();
        this.classUtils.getDeclaredFields(targetObjectClass, true).forEach(field -> this.reflectionUtils.setFieldValue(targetObject, field, this.getFieldValue(sourceObj, (Class)targetObjectClass, (Field)field, breadcrumb)));
    }

    private <T, K> void injectNotFinalFields(T sourceObj, K targetObject, String breadcrumb) {
        Class<?> targetObjectClass = targetObject.getClass();
        this.classUtils.getNotFinalFields(targetObjectClass, Boolean.valueOf(true)).forEach(field -> this.reflectionUtils.setFieldValue(targetObject, field, this.getFieldValue(sourceObj, (Class)targetObjectClass, (Field)field, breadcrumb)));
    }

    private <T, K> Object getFieldValue(T sourceObj, Class<K> targetClass, Field field, String breadcrumb) {
        String sourceFieldName = this.getSourceFieldName(field);
        return this.getFieldValue(sourceObj, sourceFieldName, targetClass, field, breadcrumb);
    }

    private <T, K> Object getFieldValue(T sourceObj, String sourceFieldName, Class<K> targetClass, Field field, String breadcrumb) {
        String fieldBreadcrumb = this.evalBreadcrumb(field.getName(), breadcrumb);
        Class<?> fieldType = field.getType();
        if (this.doSkipTransformation(fieldBreadcrumb)) {
            return Defaults.defaultValue(fieldType);
        }
        boolean primitiveType = this.classUtils.isPrimitiveType(fieldType);
        FieldTransformer transformerFunction = this.getTransformerFunction(field, fieldBreadcrumb);
        boolean isTransformerFunctionDefined = Objects.nonNull(transformerFunction);
        Object fieldValue = this.getSourceFieldValue(sourceObj, sourceFieldName, field, isTransformerFunctionDefined);
        if (Objects.nonNull(fieldValue)) {
            boolean notPrimitiveAndNotSpecialType;
            boolean bl = notPrimitiveAndNotSpecialType = !primitiveType && !this.classUtils.isSpecialType(fieldType);
            if (!isTransformerFunctionDefined && (notPrimitiveAndNotSpecialType || Optional.class.isAssignableFrom(fieldValue.getClass()))) {
                fieldValue = this.getFieldValue(targetClass, field, fieldValue, fieldBreadcrumb);
            }
        } else if (primitiveType && this.settings.isDefaultValueSetEnabled() && !isTransformerFunctionDefined) {
            fieldValue = Defaults.defaultValue(fieldType);
        }
        fieldValue = this.getTransformedValue(transformerFunction, fieldValue, sourceObj.getClass(), sourceFieldName, field, primitiveType, fieldBreadcrumb);
        return fieldValue;
    }

    private Object getTransformedValue(FieldTransformer transformerFunction, Object fieldValue, Class<?> sourceObjectClass, String sourceFieldName, Field field, boolean isDestinationFieldPrimitiveType, String breadcrumb) {
        Object transformedValue = fieldValue;
        if (this.settings.isPrimitiveTypeConversionEnabled() && isDestinationFieldPrimitiveType) {
            transformedValue = this.applyPrimitiveTypeConversion(sourceObjectClass, sourceFieldName, field, breadcrumb, transformedValue);
        }
        if (transformerFunction != null) {
            transformedValue = transformerFunction.getTransformedObject(transformedValue);
        }
        return transformedValue;
    }

    private String evalBreadcrumb(String fieldName, String breadcrumb) {
        return (StringUtils.isNotEmpty((CharSequence)breadcrumb) ? breadcrumb + Punctuation.DOT.getSymbol() : "") + fieldName;
    }

    private <T> Object getSourceFieldValue(T sourceObj, String sourceFieldName, Field field, boolean isFieldTransformerDefined) {
        Object fieldValue;
        block6: {
            fieldValue = null;
            try {
                fieldValue = this.reflectionUtils.getFieldValue(sourceObj, sourceFieldName, field.getType());
            }
            catch (MissingFieldException e) {
                if (this.classUtils.isPrimitiveType(sourceObj.getClass())) {
                    fieldValue = sourceObj;
                } else if (!isFieldTransformerDefined && !this.settings.isSetDefaultValueForMissingField()) {
                    throw e;
                }
            }
            catch (Exception e) {
                if (isFieldTransformerDefined) break block6;
                throw e;
            }
        }
        return fieldValue;
    }

    private Class<?> getSourceFieldType(Class<?> sourceObjectClass, String sourceFieldName) {
        String cacheKey = "SourceFieldType-" + sourceObjectClass.getName() + "-" + sourceFieldName;
        return this.cacheManager.getFromCache(cacheKey, Class.class).orElseGet(() -> {
            Class classType;
            block3: {
                classType = null;
                try {
                    classType = this.reflectionUtils.getDeclaredFieldType(sourceFieldName, sourceObjectClass);
                }
                catch (MissingFieldException e) {
                    if (this.classUtils.isPrimitiveType(sourceObjectClass)) {
                        classType = sourceObjectClass;
                    }
                    if (this.settings.isSetDefaultValueForMissingField()) break block3;
                    throw e;
                }
            }
            this.cacheManager.cacheObject(cacheKey, (Object)classType);
            return classType;
        });
    }

    private FieldTransformer getTransformerFunction(Field field, String breadcrumb) {
        return this.settings.getFieldsTransformers().get(this.settings.isFlatFieldNameTransformation() ? field.getName() : breadcrumb);
    }

    private Object applyPrimitiveTypeConversion(Class<?> sourceObjectClass, String sourceFieldName, Field field, String fieldTransformerKey, Object fieldValue) {
        Object transformedValue = fieldValue;
        FieldTransformer primitiveTypeTransformer = this.getPrimitiveTypeTransformer(sourceObjectClass, sourceFieldName, field, fieldTransformerKey);
        if (Objects.nonNull(primitiveTypeTransformer)) {
            transformedValue = primitiveTypeTransformer.getTransformedObject(fieldValue);
        }
        return transformedValue;
    }

    private FieldTransformer getPrimitiveTypeTransformer(Class<?> sourceObjectClass, String sourceFieldName, Field field, String fieldTransformerKey) {
        String cacheKey = "TransformerFunction-" + field.getDeclaringClass().getName() + "-" + fieldTransformerKey + "-" + field.getName();
        return this.cacheManager.getFromCache(cacheKey, FieldTransformer.class).orElseGet(() -> {
            FieldTransformer primitiveTypeTransformer = null;
            Class<?> sourceFieldType = this.getSourceFieldType(sourceObjectClass, sourceFieldName);
            if (Objects.nonNull(sourceFieldType)) {
                primitiveTypeTransformer = this.conversionAnalyzer.getConversionFunction(sourceFieldType, field.getType()).map(conversionFunction -> new FieldTransformer(fieldTransformerKey, conversionFunction)).orElse(null);
            }
            this.cacheManager.cacheObject(cacheKey, primitiveTypeTransformer);
            return primitiveTypeTransformer;
        });
    }

    private <K> Object getFieldValue(Class<K> targetClass, Field field, Object fieldValue, String breadcrumb) {
        return PopulatorFactory.getPopulator(field.getType(), fieldValue.getClass(), this).map(populator -> populator.getPopulatedObject(targetClass, field.getName(), fieldValue)).orElseGet(() -> this.transform(fieldValue, field.getType(), breadcrumb));
    }
}

