/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.transformer.cache;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class CacheManager {
    private final Map<String, Object> cacheMap;

    public <T> void cacheObject(String cacheKey, T object) {
        this.cacheObject(cacheKey, object, null);
    }

    public <T> void cacheObject(String cacheKey, T object, Object defaultValue) {
        if (Objects.nonNull(object)) {
            this.cacheMap.put(cacheKey, object);
        } else if (Objects.nonNull(defaultValue)) {
            this.cacheMap.put(cacheKey, defaultValue);
        }
    }

    public <T> Optional<T> getFromCache(String cacheKey, Class<? extends T> objectClass) {
        return Optional.ofNullable(this.cacheMap.get(cacheKey)).map(objectClass::cast);
    }

    public void removeFromCache(String cacheKey) {
        Optional.ofNullable(cacheKey).ifPresent(this.cacheMap::remove);
    }

    public void removeMatchingKeys(String regex) {
        this.cacheMap.keySet().removeIf(key -> key.matches(regex));
    }

    protected CacheManager(Map<String, Object> cacheMap) {
        this.cacheMap = cacheMap;
    }
}

