/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.transformer.model;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class FieldTransformer<T, K> {
    private final String destFieldName;
    private final Function<T, K> transformerFunction;
    private final Supplier<K> transformerSupplier;

    public FieldTransformer(String destinationFieldName, Function<T, K> fieldTransformerFunction) {
        this(destinationFieldName, fieldTransformerFunction, null);
    }

    public FieldTransformer(String destinationFieldName, Supplier<K> fieldTransformerSupplier) {
        this(destinationFieldName, null, fieldTransformerSupplier);
    }

    public final K getTransformedObject(T objectToTransform) {
        return Objects.nonNull(this.transformerFunction) ? this.transformerFunction.apply(objectToTransform) : this.transformerSupplier.get();
    }

    private FieldTransformer(String destFieldName, Function<T, K> transformerFunction, Supplier<K> transformerSupplier) {
        this.destFieldName = destFieldName;
        this.transformerFunction = transformerFunction;
        this.transformerSupplier = transformerSupplier;
    }

    public String getDestFieldName() {
        return this.destFieldName;
    }

    public Function<T, K> getTransformerFunction() {
        return this.transformerFunction;
    }

    public Supplier<K> getTransformerSupplier() {
        return this.transformerSupplier;
    }

    public String toString() {
        return "FieldTransformer(destFieldName=" + this.getDestFieldName() + ", transformerFunction=" + this.getTransformerFunction() + ", transformerSupplier=" + this.getTransformerSupplier() + ")";
    }
}

