/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.transformer.model;

import com.hotels.transformer.model.MapElemType;

public class ItemType
implements MapElemType {
    private final Class<?> objectClass;
    private final Class<?> genericClass;

    ItemType(Class<?> objectClass, Class<?> genericClass) {
        this.objectClass = objectClass;
        this.genericClass = genericClass;
    }

    public static ItemTypeBuilder builder() {
        return new ItemTypeBuilder();
    }

    public Class<?> getObjectClass() {
        return this.objectClass;
    }

    public Class<?> getGenericClass() {
        return this.genericClass;
    }

    public static class ItemTypeBuilder {
        private Class<?> objectClass;
        private Class<?> genericClass;

        ItemTypeBuilder() {
        }

        public ItemTypeBuilder objectClass(Class<?> objectClass) {
            this.objectClass = objectClass;
            return this;
        }

        public ItemTypeBuilder genericClass(Class<?> genericClass) {
            this.genericClass = genericClass;
            return this;
        }

        public ItemType build() {
            return new ItemType(this.objectClass, this.genericClass);
        }

        public String toString() {
            return "ItemType.ItemTypeBuilder(objectClass=" + this.objectClass + ", genericClass=" + this.genericClass + ")";
        }
    }
}

