/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.transformer.utils;

import com.hotels.transformer.base.Defaults;
import com.hotels.transformer.cache.CacheManager;
import com.hotels.transformer.cache.CacheManagerFactory;
import com.hotels.transformer.constant.ClassType;
import com.hotels.transformer.constant.Filters;
import com.hotels.transformer.error.InstanceCreationException;
import com.hotels.transformer.error.InvalidBeanException;
import com.hotels.transformer.utils.ReflectionUtils;
import com.hotels.transformer.validator.Validator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ClassUtils {
    private static final String CLAZZ_CANNOT_BE_NULL = "clazz cannot be null!";
    private static final CacheManager CACHE_MANAGER = CacheManagerFactory.getCacheManager("classUtils");
    private static final Set<Class<?>> PRIMITIVE_TYPES = new HashSet<Class>(Arrays.asList(String.class, Boolean.class, Integer.class, Long.class, Double.class, BigDecimal.class, BigInteger.class, Short.class, Float.class, Character.class, Byte.class, Void.class));
    private final ReflectionUtils reflectionUtils = new ReflectionUtils();

    public boolean isPrimitiveOrSpecialType(Class<?> clazz) {
        String cacheKey = "isPrimitiveOrSpecial-" + clazz.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, Boolean.class).orElseGet(() -> {
            Boolean res = this.isPrimitiveType(clazz) || this.isSpecialType(clazz);
            CACHE_MANAGER.cacheObject(cacheKey, res);
            return res;
        });
    }

    public boolean isPrimitiveType(Class<?> clazz) {
        String cacheKey = "isPrimitive-" + clazz.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, Boolean.class).orElseGet(() -> {
            Boolean res = clazz.isPrimitive() || PRIMITIVE_TYPES.contains(clazz) || clazz.isEnum();
            CACHE_MANAGER.cacheObject(cacheKey, res);
            return res;
        });
    }

    public boolean isPrimitiveTypeArray(Class<?> clazz) {
        String cacheKey = "isPrimitiveTypeArray-" + clazz.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, Boolean.class).orElseGet(() -> {
            Boolean res = clazz.isArray() && this.isPrimitiveType(clazz.getComponentType());
            CACHE_MANAGER.cacheObject(cacheKey, res);
            return res;
        });
    }

    public boolean isSpecialType(Class<?> clazz) {
        String cacheKey = "isSpecial-" + clazz.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, Boolean.class).orElseGet(() -> {
            Boolean res = clazz.equals(Currency.class) || clazz.equals(Locale.class) || Temporal.class.isAssignableFrom(clazz) || clazz.isSynthetic();
            CACHE_MANAGER.cacheObject(cacheKey, res);
            return res;
        });
    }

    public static boolean isDouble(Class<?> type) {
        return Double.class.isAssignableFrom(type) || type == Double.TYPE;
    }

    public static boolean isFloat(Class<?> type) {
        return Float.class.isAssignableFrom(type) || type == Float.TYPE;
    }

    public static boolean isLong(Class<?> type) {
        return Long.class.isAssignableFrom(type) || type == Long.TYPE;
    }

    public static boolean isShort(Class<?> type) {
        return Short.class.isAssignableFrom(type) || type == Short.TYPE;
    }

    public static boolean isInt(Class<?> type) {
        return Integer.class.isAssignableFrom(type) || type == Integer.TYPE;
    }

    public static boolean isByte(Class<?> type) {
        return Byte.class.isAssignableFrom(type) || type == Byte.TYPE;
    }

    public static boolean isChar(Class<?> type) {
        return Character.class.isAssignableFrom(type) || type == Character.TYPE;
    }

    public static boolean isBoolean(Class<?> type) {
        return Boolean.class.isAssignableFrom(type) || type == Boolean.TYPE;
    }

    public static boolean isString(Class<?> type) {
        return type == String.class;
    }

    public static boolean isBigInteger(Class<?> type) {
        return type == BigInteger.class;
    }

    public static boolean isBigDecimal(Class<?> type) {
        return type == BigDecimal.class;
    }

    public static boolean isByteArray(Class<?> type) {
        return type == byte[].class;
    }

    public List<Field> getPrivateFinalFields(Class<?> clazz) {
        Validator.notNull(clazz, CLAZZ_CANNOT_BE_NULL);
        String cacheKey = "PrivateFinalFields-" + clazz.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, List.class).orElseGet(() -> {
            ArrayList<Field> res = new ArrayList<Field>();
            if (Objects.nonNull(clazz.getSuperclass()) && !clazz.getSuperclass().equals(Object.class)) {
                res.addAll(this.getPrivateFinalFields(clazz.getSuperclass()));
            }
            res.addAll(Arrays.stream(this.getDeclaredFields(clazz)).filter(Filters.IS_FINAL_AND_NOT_STATIC_FIELD).collect(Collectors.toList()));
            CACHE_MANAGER.cacheObject(cacheKey, res);
            return res;
        });
    }

    public int getTotalFields(Class<?> clazz, Predicate<? super Field> predicate) {
        Validator.notNull(clazz, CLAZZ_CANNOT_BE_NULL);
        String cacheKey = "TotalFields-" + clazz.getName() + '-' + predicate;
        return CACHE_MANAGER.getFromCache(cacheKey, Integer.class).orElseGet(() -> {
            List<Field> declaredFields = this.getDeclaredFields(clazz, true);
            int res = Optional.ofNullable(predicate).map(filter -> (int)declaredFields.stream().filter(filter).count()).orElseGet(declaredFields::size);
            CACHE_MANAGER.cacheObject(cacheKey, res);
            return res;
        });
    }

    public List<Field> getPrivateFields(Class<?> clazz) {
        return this.getPrivateFields(clazz, false);
    }

    public List<Field> getPrivateFields(Class<?> clazz, boolean skipFinal) {
        Validator.notNull(clazz, CLAZZ_CANNOT_BE_NULL);
        String cacheKey = "PrivateFields-" + clazz.getName() + "-skipFinal-" + skipFinal;
        return CACHE_MANAGER.getFromCache(cacheKey, List.class).orElseGet(() -> {
            ArrayList<Field> res = new ArrayList<Field>();
            if (Objects.nonNull(clazz.getSuperclass()) && !clazz.getSuperclass().equals(Object.class)) {
                res.addAll(this.getPrivateFields(clazz.getSuperclass(), skipFinal));
            }
            res.addAll(Arrays.stream(this.getDeclaredFields(clazz)).filter(field -> Modifier.isPrivate(field.getModifiers()) && (!skipFinal || !Modifier.isFinal(field.getModifiers())) && !Modifier.isStatic(field.getModifiers())).collect(Collectors.toList()));
            CACHE_MANAGER.cacheObject(cacheKey, res);
            return res;
        });
    }

    public List<Field> getDeclaredFields(Class<?> clazz, boolean skipStatic) {
        String cacheKey = "DeclaredFields-" + clazz.getName() + "-skipStatic-" + skipStatic;
        return CACHE_MANAGER.getFromCache(cacheKey, List.class).orElseGet(() -> {
            ArrayList<Field> res = new ArrayList<Field>();
            if (Objects.nonNull(clazz.getSuperclass()) && !clazz.getSuperclass().equals(Object.class)) {
                res.addAll(this.getDeclaredFields(clazz.getSuperclass(), skipStatic));
            }
            Arrays.stream(this.getDeclaredFields(clazz)).filter(field -> !skipStatic || !Modifier.isStatic(field.getModifiers())).forEach(field -> {
                field.setAccessible(true);
                res.add((Field)field);
            });
            CACHE_MANAGER.cacheObject(cacheKey, res);
            return res;
        });
    }

    private Field[] getDeclaredFields(Class<?> clazz) {
        String cacheKey = "ClassDeclaredFields-" + clazz.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, Field[].class).orElseGet(() -> {
            Field[] res = clazz.getDeclaredFields();
            CACHE_MANAGER.cacheObject(cacheKey, res);
            return res;
        });
    }

    public <K> boolean hasAccessibleConstructors(Class<K> targetClass) {
        String cacheKey = "HasAccessibleConstructors-" + targetClass.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, Boolean.class).orElseGet(() -> {
            boolean res = Arrays.stream(targetClass.getDeclaredConstructors()).anyMatch(constructor -> Modifier.isPublic(constructor.getModifiers()));
            CACHE_MANAGER.cacheObject(cacheKey, res);
            return res;
        });
    }

    public Class[] getDeclaredClasses(Class<?> clazz) {
        Validator.notNull(clazz, CLAZZ_CANNOT_BE_NULL);
        String cacheKey = "DeclaredClasses-" + clazz.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, Class[].class).orElseGet(() -> {
            Class[] declaredClasses = clazz.getDeclaredClasses();
            CACHE_MANAGER.cacheObject(cacheKey, declaredClasses);
            return declaredClasses;
        });
    }

    public <T> T getInstance(Constructor constructor, Object ... constructorArgs) {
        try {
            return constructor.newInstance(constructorArgs);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new InstanceCreationException(e.getMessage(), e);
        }
    }

    public <K> Constructor getNoArgsConstructor(Class<K> clazz) {
        String cacheKey = "NoArgsConstructor-" + clazz.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, Constructor.class).orElseGet(() -> {
            Constructor<?>[] declaredConstructors = clazz.getDeclaredConstructors();
            Constructor constructor = Collections.min(Arrays.asList(declaredConstructors), Comparator.comparing(Constructor::getParameterCount));
            if (constructor.getParameterCount() != 0) {
                throw new InvalidBeanException("No default constructors available");
            }
            constructor.setAccessible(true);
            CACHE_MANAGER.cacheObject(cacheKey, constructor);
            return constructor;
        });
    }

    public <K> Constructor getAllArgsConstructor(Class<K> clazz) {
        String cacheKey = "AllArgsConstructor-" + clazz.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, Constructor.class).orElseGet(() -> {
            Constructor<?>[] declaredConstructors = clazz.getDeclaredConstructors();
            Constructor constructor = Collections.max(Arrays.asList(declaredConstructors), Comparator.comparing(Constructor::getParameterCount));
            constructor.setAccessible(true);
            CACHE_MANAGER.cacheObject(cacheKey, constructor);
            return constructor;
        });
    }

    public Parameter[] getConstructorParameters(Constructor constructor) {
        String cacheKey = "ConstructorParams-" + constructor.getDeclaringClass().getName() + '-' + constructor.getParameterCount();
        return CACHE_MANAGER.getFromCache(cacheKey, Parameter[].class).orElseGet(() -> {
            Parameter[] parameters = constructor.getParameters();
            CACHE_MANAGER.cacheObject(cacheKey, parameters);
            return parameters;
        });
    }

    public boolean hasField(Object target, String fieldName) {
        String cacheKey = "ClassHasField-" + target.getClass().getName() + '-' + fieldName;
        return CACHE_MANAGER.getFromCache(cacheKey, Boolean.class).orElseGet(() -> {
            boolean hasField;
            block2: {
                try {
                    hasField = Objects.nonNull(target.getClass().getDeclaredField(fieldName));
                }
                catch (NoSuchFieldException e) {
                    hasField = false;
                    Class<?> superclass = target.getClass().getSuperclass();
                    if (!Objects.nonNull(superclass) || superclass.equals(Object.class)) break block2;
                    hasField = this.hasField(superclass, fieldName);
                }
            }
            CACHE_MANAGER.cacheObject(cacheKey, hasField);
            return hasField;
        });
    }

    public boolean hasSetterMethods(Class<?> clazz) {
        Validator.notNull(clazz, CLAZZ_CANNOT_BE_NULL);
        String cacheKey = "HasSetterMethods-" + clazz.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, Boolean.class).orElseGet(() -> {
            Boolean res = Arrays.stream(this.getDeclaredMethods(clazz)).anyMatch(this.reflectionUtils::isSetter);
            CACHE_MANAGER.cacheObject(cacheKey, res);
            return res;
        });
    }

    private Method[] getDeclaredMethods(Class<?> clazz) {
        Validator.notNull(clazz, CLAZZ_CANNOT_BE_NULL);
        String cacheKey = "DeclaredMethods-" + clazz.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, Method[].class).orElseGet(() -> {
            Method[] res = clazz.getDeclaredMethods();
            CACHE_MANAGER.cacheObject(cacheKey, res);
            return res;
        });
    }

    public boolean hasFinalFields(Class<?> clazz) {
        Validator.notNull(clazz, CLAZZ_CANNOT_BE_NULL);
        return this.hasFieldsMatchingCondition(clazz, Filters.IS_FINAL_AND_NOT_STATIC_FIELD, "HasFinalNotStaticFields-");
    }

    private boolean hasNotFinalFields(Class<?> clazz) {
        Validator.notNull(clazz, CLAZZ_CANNOT_BE_NULL);
        return this.hasFieldsMatchingCondition(clazz, Filters.IS_NOT_FINAL_AND_NOT_STATIC_FIELD, "HasNotFinalNotStaticFields-");
    }

    private boolean hasFieldsMatchingCondition(Class<?> clazz, Predicate<Field> filterPredicate, String cacheKey) {
        return CACHE_MANAGER.getFromCache(cacheKey + clazz.getName(), Boolean.class).orElseGet(() -> {
            boolean res = Arrays.stream(this.getDeclaredFields(clazz)).anyMatch(filterPredicate);
            if (!res && Objects.nonNull(clazz.getSuperclass()) && !clazz.getSuperclass().equals(Object.class)) {
                Class superclass = clazz.getSuperclass();
                res = this.hasFieldsMatchingCondition(superclass, filterPredicate, cacheKey);
            }
            CACHE_MANAGER.cacheObject(cacheKey + clazz.getName(), res);
            return res;
        });
    }

    public boolean containsAnnotation(Constructor constructor, Class<? extends Annotation> annotationClass) {
        String cacheKey = "ConstructorHasAnnotation-" + constructor.getDeclaringClass().getName() + '-' + annotationClass.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, Boolean.class).orElseGet(() -> {
            boolean containsAnnotation = Arrays.stream(constructor.getParameters()).noneMatch(parameter -> Objects.isNull(parameter.getAnnotation(annotationClass)));
            CACHE_MANAGER.cacheObject(cacheKey, containsAnnotation);
            return containsAnnotation;
        });
    }

    public boolean allParameterAnnotatedWith(Constructor constructor, Class<? extends Annotation> annotationClass) {
        String cacheKey = "AllParameterAnnotatedWith-" + constructor.getDeclaringClass().getName() + '-' + annotationClass.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, Boolean.class).orElseGet(() -> {
            boolean notAllAnnotatedWith = Arrays.stream(constructor.getParameters()).allMatch(parameter -> Objects.nonNull(parameter.getAnnotation(annotationClass)));
            CACHE_MANAGER.cacheObject(cacheKey, notAllAnnotatedWith);
            return notAllAnnotatedWith;
        });
    }

    public boolean areParameterNamesAvailable(Constructor constructor) {
        String cacheKey = "AreParameterNamesAvailable-" + constructor.getDeclaringClass().getName();
        return CACHE_MANAGER.getFromCache(cacheKey, Boolean.class).orElseGet(() -> {
            boolean res = Arrays.stream(this.getConstructorParameters(constructor)).anyMatch(Parameter::isNamePresent);
            CACHE_MANAGER.cacheObject(cacheKey, res);
            return res;
        });
    }

    public ClassType getClassType(Class<?> clazz) {
        String cacheKey = "ClassType-" + clazz.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, ClassType.class).orElseGet(() -> {
            boolean hasNotFinalFields;
            boolean hasFinalFields = this.hasFinalFields(clazz);
            ClassType classType = !hasFinalFields ? ClassType.MUTABLE : ((hasNotFinalFields = this.hasNotFinalFields(clazz)) ? ClassType.MIXED : ClassType.IMMUTABLE);
            CACHE_MANAGER.cacheObject(cacheKey, classType);
            return classType;
        });
    }

    public List<Method> getSetterMethods(Class<?> clazz) {
        Validator.notNull(clazz, CLAZZ_CANNOT_BE_NULL);
        String cacheKey = "SetterMethods-" + clazz.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, List.class).orElseGet(() -> {
            LinkedList<Method> setterMethods = new LinkedList<Method>();
            if (Objects.nonNull(clazz.getSuperclass()) && !clazz.getSuperclass().equals(Object.class)) {
                setterMethods.addAll(this.getSetterMethods(clazz.getSuperclass()));
            }
            setterMethods.addAll(Arrays.stream(this.getDeclaredMethods(clazz)).filter(this.reflectionUtils::isSetter).collect(Collectors.toList()));
            CACHE_MANAGER.cacheObject(cacheKey, setterMethods);
            return setterMethods;
        });
    }

    public Object getDefaultTypeValue(Class<?> objectType) {
        String cacheKey = "DefaultTypeValue-" + objectType.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, Object.class).orElseGet(() -> {
            Object defaultValue = this.isPrimitiveType(objectType) ? Defaults.defaultValue(objectType) : null;
            CACHE_MANAGER.cacheObject(cacheKey, defaultValue);
            return defaultValue;
        });
    }

    public List<Field> getNotFinalFields(Class<?> clazz, Boolean skipStatic) {
        String cacheKey = "NotFinalFields-" + clazz.getName() + "-" + skipStatic;
        return CACHE_MANAGER.getFromCache(cacheKey, List.class).orElseGet(() -> {
            List notFinalFields = this.getDeclaredFields(clazz, skipStatic).stream().filter(Filters.IS_NOT_FINAL_FIELD).collect(Collectors.toList());
            CACHE_MANAGER.cacheObject(cacheKey, notFinalFields);
            return notFinalFields;
        });
    }
}

