/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.transformer.utils;

import com.hotels.transformer.cache.CacheManager;
import com.hotels.transformer.cache.CacheManagerFactory;
import com.hotels.transformer.constant.MethodPrefix;
import com.hotels.transformer.error.MissingFieldException;
import com.hotels.transformer.error.MissingMethodException;
import com.hotels.transformer.model.EmptyValue;
import com.hotels.transformer.model.ItemType;
import com.hotels.transformer.model.MapElemType;
import com.hotels.transformer.model.MapType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;

public final class ReflectionUtils {
    private static final String BOOLEAN = "boolean";
    private static final String SETTER_METHOD_NAME_REGEX = "^set[A-Z].*";
    private static final String DOT_SPLIT_REGEX = "\\.";
    private static final CacheManager CACHE_MANAGER = CacheManagerFactory.getCacheManager("reflectionUtils");

    protected Object invokeMethod(Method method, Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception e) {
            this.handleReflectionException(e);
            throw new IllegalStateException(e);
        }
    }

    public boolean isSetter(Method method) {
        String cacheKey = "IsSetter-" + method.getDeclaringClass().getName() + '-' + method.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, Boolean.class).orElseGet(() -> {
            boolean res = Modifier.isPublic(method.getModifiers()) && method.getName().matches(SETTER_METHOD_NAME_REGEX) && method.getParameterTypes().length == 1 && method.getReturnType().equals(Void.TYPE);
            CACHE_MANAGER.cacheObject(cacheKey, res);
            return res;
        });
    }

    public Object getFieldValue(Object target, Field field) {
        return this.getFieldValue(target, field.getName(), field.getType());
    }

    public Object getFieldValue(Object target, String fieldName, Class<?> fieldType) {
        Object fieldValue = this.getRealTarget(target);
        for (String currFieldName : fieldName.split(DOT_SPLIT_REGEX)) {
            if (fieldValue == null) break;
            try {
                fieldValue = this.getFieldValueDirectAccess(fieldValue, currFieldName);
            }
            catch (Exception e) {
                fieldValue = this.invokeMethod(this.getGetterMethod(fieldValue.getClass(), currFieldName, fieldType), fieldValue, new Object[0]);
            }
        }
        return fieldValue;
    }

    private Method getGetterMethod(Class<?> fieldClass, String fieldName, Class<?> fieldType) {
        String cacheKey = "GetterMethod-" + fieldClass.getName() + '-' + fieldName;
        return CACHE_MANAGER.getFromCache(cacheKey, Method.class).orElseGet(() -> {
            try {
                Method method = fieldClass.getMethod(this.getGetterMethodPrefix(fieldType) + StringUtils.capitalize((String)fieldName), new Class[0]);
                method.setAccessible(true);
                CACHE_MANAGER.cacheObject(cacheKey, method);
                return method;
            }
            catch (NoSuchMethodException e) {
                throw new MissingFieldException(fieldClass.getName() + " hasn't a field called: " + fieldName + ".");
            }
        });
    }

    public <A extends Annotation> A getFieldAnnotation(Field field, Class<A> annotationClazz) {
        String cacheKey = "FieldAnnotation-" + field.getDeclaringClass().getName() + "-" + field.getName() + "-" + annotationClazz.getName();
        return (A)CACHE_MANAGER.getFromCache(cacheKey, annotationClazz).orElseGet(() -> {
            Annotation annotation = null;
            if (field.isAnnotationPresent(annotationClazz)) {
                annotation = (Annotation)field.getAnnotation(annotationClazz);
            }
            CACHE_MANAGER.cacheObject(cacheKey, annotation);
            return annotation;
        });
    }

    public <A extends Annotation> A getParameterAnnotation(Parameter parameter, Class<A> annotationClazz, String declaringClassName) {
        String cacheKey = "ParameterAnnotation-" + declaringClassName + "-" + parameter.getName() + "-" + annotationClazz.getName();
        return (A)CACHE_MANAGER.getFromCache(cacheKey, annotationClazz).orElseGet(() -> {
            Annotation annotation = null;
            if (parameter.isAnnotationPresent(annotationClazz)) {
                annotation = (Annotation)parameter.getAnnotation(annotationClazz);
            }
            CACHE_MANAGER.cacheObject(cacheKey, annotation);
            return annotation;
        });
    }

    private Object getFieldValueDirectAccess(Object target, String fieldName) {
        try {
            Field field = this.getDeclaredField(fieldName, target.getClass());
            return field.get(target);
        }
        catch (MissingFieldException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleReflectionException(e);
            throw new IllegalStateException(e);
        }
    }

    private Field getClassDeclaredField(String fieldName, Class<?> targetClass) {
        String cacheKey = "ClassDeclaredField-" + targetClass.getName() + "-" + fieldName;
        return CACHE_MANAGER.getFromCache(cacheKey, Field.class).orElseGet(() -> {
            Field field;
            try {
                field = targetClass.getDeclaredField(fieldName);
                field.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                Class superclass = targetClass.getSuperclass();
                if (!superclass.equals(Object.class)) {
                    field = this.getClassDeclaredField(fieldName, superclass);
                }
                throw new MissingFieldException(targetClass.getName() + " does not contain field: " + fieldName);
            }
            catch (Exception e) {
                this.handleReflectionException(e);
                throw new IllegalStateException(e);
            }
            CACHE_MANAGER.cacheObject(cacheKey, field);
            return field;
        });
    }

    public Field getDeclaredField(String fieldName, Class<?> targetClass) {
        String cacheKey = "ClassDeclaredFieldDotNotation-" + targetClass.getName() + "-" + fieldName;
        return CACHE_MANAGER.getFromCache(cacheKey, Field.class).orElseGet(() -> {
            Field field = null;
            Class<?> currentClass = targetClass;
            for (String currFieldName : fieldName.split(DOT_SPLIT_REGEX)) {
                field = this.getClassDeclaredField(currFieldName, currentClass);
                currentClass = field.getType();
            }
            CACHE_MANAGER.cacheObject(cacheKey, field);
            return field;
        });
    }

    public Class<?> getDeclaredFieldType(String fieldName, Class<?> clazz) {
        String cacheKey = "FieldType-" + clazz.getName() + "-" + fieldName;
        return CACHE_MANAGER.getFromCache(cacheKey, Class.class).orElseGet(() -> {
            Class<?> fieldType = this.getDeclaredField(fieldName, clazz).getType();
            CACHE_MANAGER.cacheObject(cacheKey, fieldType);
            return fieldType;
        });
    }

    public void setFieldValue(Object target, Field field, Object fieldValue) {
        try {
            this.setFieldValueWithoutSetterMethod(target, field, fieldValue);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            this.invokeMethod(this.getSetterMethodForField(target.getClass(), field.getName(), field.getType()), target, fieldValue);
        }
    }

    private void setFieldValueWithoutSetterMethod(Object target, Field field, Object fieldValue) {
        try {
            field.set(target, fieldValue);
        }
        catch (Exception e) {
            this.handleReflectionException(e);
            throw new IllegalStateException(e);
        }
    }

    private Object getRealTarget(Object target) {
        AtomicReference<Object> realTarget = new AtomicReference<Object>(target);
        if (this.isOptionalType(target)) {
            ((Optional)target).ifPresent(realTarget::set);
        }
        return realTarget.get();
    }

    private boolean isOptionalType(Object object) {
        return object instanceof Optional;
    }

    private String getGetterMethodPrefix(Class<?> fieldType) {
        String cacheKey = "GetterMethodPrefix-" + fieldType.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, String.class).orElseGet(() -> {
            String res = Boolean.class.equals((Object)fieldType) || fieldType.getName().equals(BOOLEAN) ? MethodPrefix.IS.getPrefix() : MethodPrefix.GET.getPrefix();
            CACHE_MANAGER.cacheObject(cacheKey, res);
            return res;
        });
    }

    public Method getSetterMethodForField(Class<?> fieldClass, String fieldName, Class<?> fieldType) {
        String cacheKey = "SetterMethod-" + fieldClass.getName() + '-' + fieldName;
        return CACHE_MANAGER.getFromCache(cacheKey, Method.class).orElseGet(() -> {
            try {
                Method method = fieldClass.getMethod(MethodPrefix.SET.getPrefix() + StringUtils.capitalize((String)fieldName), fieldType);
                method.setAccessible(true);
                CACHE_MANAGER.cacheObject(cacheKey, method);
                return method;
            }
            catch (NoSuchMethodException e) {
                throw new MissingMethodException(e.getMessage());
            }
        });
    }

    public Class<?> getGenericFieldType(Field field) {
        String cacheKey = "GenericFieldType-" + field.getDeclaringClass().getName() + '-' + field.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, Class.class).orElseGet(() -> {
            Type[] fieldArgTypes;
            Class res = null;
            if (ParameterizedType.class.isAssignableFrom(field.getGenericType().getClass()) && (fieldArgTypes = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()).length != 0) {
                res = (Class)fieldArgTypes[0];
            }
            CACHE_MANAGER.cacheObject(cacheKey, res);
            return res;
        });
    }

    public MapType getMapGenericType(Type fieldType, String declaringClass, String fieldName) {
        Class<?> fieldClass = this.getArgumentTypeClass(fieldType, declaringClass, fieldName, false);
        String cacheKey = "MapGenericFieldType-" + fieldClass.getName() + '-' + fieldName;
        return CACHE_MANAGER.getFromCache(cacheKey, MapType.class).orElseGet(() -> {
            if (!Map.class.isAssignableFrom(fieldClass)) {
                throw new IllegalArgumentException("Type for object: " + fieldName + " is invalid. It cannot be assigned from: " + Map.class.getName() + ".");
            }
            ParameterizedType genericType = (ParameterizedType)fieldType;
            MapElemType keyType = this.getMapElemType(genericType.getActualTypeArguments()[0], declaringClass, fieldName);
            MapElemType elemType = this.getMapElemType(genericType.getActualTypeArguments()[1], declaringClass, fieldName);
            MapType mapType = new MapType(keyType, elemType);
            CACHE_MANAGER.cacheObject(cacheKey, mapType);
            return mapType;
        });
    }

    private MapElemType getMapElemType(Type fieldType, String declaringClass, String fieldName) {
        String cacheKey = "MapElemType-" + declaringClass + "-" + fieldType.getTypeName() + '-' + fieldName;
        return CACHE_MANAGER.getFromCache(cacheKey, MapElemType.class).orElseGet(() -> {
            Class<?> argumentTypeClass = this.getArgumentTypeClass(fieldType, declaringClass, fieldName, false);
            MapElemType res = Map.class.isAssignableFrom(argumentTypeClass) ? this.getMapGenericType(fieldType, declaringClass, fieldName) : this.buildItemType(fieldType, declaringClass, fieldName);
            CACHE_MANAGER.cacheObject(cacheKey, res);
            return res;
        });
    }

    private ItemType buildItemType(Object argument, String declaringClass, String fieldName) {
        return ItemType.builder().objectClass(this.getArgumentTypeClass(argument, declaringClass, fieldName, false)).genericClass(this.getArgumentTypeClass(argument, declaringClass, fieldName, true)).build();
    }

    public Class<?> getArgumentTypeClass(Object argument, String declaringClass, String fieldName, boolean getNestedGenericClass) {
        boolean argumentIsTypeClass = argument instanceof Class;
        String cacheKey = "ArgumentTypeClass-" + declaringClass + "-" + fieldName + "-" + getNestedGenericClass + "--" + (argumentIsTypeClass || !List.class.isAssignableFrom(argument.getClass()) ? argument : argument.getClass());
        return CACHE_MANAGER.getFromCache(cacheKey, Class.class).map(atc -> atc == EmptyValue.class ? null : atc).orElseGet(() -> {
            Class res = null;
            if (argumentIsTypeClass) {
                res = getNestedGenericClass ? null : (Class)argument;
            } else if (ParameterizedType.class.isAssignableFrom(argument.getClass())) {
                res = getNestedGenericClass ? this.getArgumentTypeClass(((ParameterizedType)((Object)argument)).getActualTypeArguments()[0], declaringClass, fieldName, false) : (Class<?>)((ParameterizedType)((Object)argument)).getRawType();
            }
            CACHE_MANAGER.cacheObject(cacheKey, res, EmptyValue.class);
            return res;
        });
    }

    public Class<?> getArrayType(Field arrayField) {
        String cacheKey = "ArrayType-" + arrayField.getDeclaringClass().getName();
        return CACHE_MANAGER.getFromCache(cacheKey, Class.class).orElseGet(() -> {
            Class<?> arrayType = arrayField.getType().getComponentType();
            CACHE_MANAGER.cacheObject(cacheKey, arrayType);
            return arrayType;
        });
    }

    void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new MissingMethodException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method: " + ex.getMessage(), ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }
}

