/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.transformer.validator;

import com.hotels.transformer.cache.CacheManager;
import com.hotels.transformer.cache.CacheManagerFactory;
import com.hotels.transformer.constant.Punctuation;
import com.hotels.transformer.error.InvalidBeanException;
import com.hotels.transformer.validator.Validator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;

public class ValidatorImpl
implements Validator {
    private final CacheManager cacheManager = CacheManagerFactory.getCacheManager("validatorImpl");

    @Override
    public final <K> Set<ConstraintViolation<Object>> getConstraintViolations(K k) {
        return this.getValidator().validate(k, new Class[0]);
    }

    @Override
    public final <K> List<String> getConstraintViolationsMessages(K k) {
        return this.getConstraintViolations(k).stream().map(cv -> cv.getRootBeanClass().getName() + Punctuation.DOT.getSymbol() + cv.getPropertyPath() + " " + cv.getMessage()).collect(Collectors.toList());
    }

    @Override
    public final <K> void validate(K k) {
        Set<ConstraintViolation<Object>> constraintViolations = this.getConstraintViolations(k);
        if (!constraintViolations.isEmpty()) {
            String errors = constraintViolations.stream().map(cv -> cv.getRootBeanClass().getName() + Punctuation.DOT.getSymbol() + cv.getPropertyPath() + " " + cv.getMessage()).collect(Collectors.joining(Punctuation.SEMICOLON.getSymbol()));
            throw new InvalidBeanException(errors);
        }
    }

    private javax.validation.Validator getValidator() {
        String cacheKey = "BeanValidator";
        return this.cacheManager.getFromCache(cacheKey, javax.validation.Validator.class).orElseGet(() -> {
            javax.validation.Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
            this.cacheManager.cacheObject(cacheKey, validator);
            return validator;
        });
    }
}

