/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.transformer;

import com.hotels.transformer.Transformer;
import com.hotels.transformer.cache.CacheManager;
import com.hotels.transformer.cache.CacheManagerFactory;
import com.hotels.transformer.model.FieldMapping;
import com.hotels.transformer.model.FieldTransformer;
import com.hotels.transformer.model.TransformerSettings;
import com.hotels.transformer.utils.ClassUtils;
import com.hotels.transformer.utils.ReflectionUtils;
import com.hotels.transformer.validator.Validator;
import java.util.Map;
import lombok.Generated;

public abstract class AbstractTransformer<T extends Transformer, P, S extends TransformerSettings<P>>
implements Transformer<T> {
    protected final ReflectionUtils reflectionUtils = new ReflectionUtils();
    protected final ClassUtils classUtils = new ClassUtils();
    protected final CacheManager cacheManager;
    protected final String transformerFunctionRegex;
    protected final S settings;

    protected AbstractTransformer(String transformerFunctionCachePrefix, String cacheName, S transformerSettings) {
        this.settings = transformerSettings;
        this.transformerFunctionRegex = "^" + transformerFunctionCachePrefix + ".*";
        this.cacheManager = CacheManagerFactory.getCacheManager(cacheName);
    }

    @Override
    public final T withFieldMapping(FieldMapping ... fieldMapping) {
        Map fieldsNameMapping = ((TransformerSettings)this.settings).getFieldsNameMapping();
        for (FieldMapping mapping : fieldMapping) {
            fieldsNameMapping.put(mapping.getDestFieldName(), mapping.getSourceFieldName());
        }
        return (T)this;
    }

    @Override
    public final T withFieldTransformer(FieldTransformer ... fieldTransformer) {
        Map fieldsTransformers = ((TransformerSettings)this.settings).getFieldsTransformers();
        for (FieldTransformer transformer : fieldTransformer) {
            fieldsTransformers.put(transformer.getDestFieldName(), transformer);
        }
        return (T)this;
    }

    @Override
    public final void removeFieldMapping(String destFieldName) {
        Validator.notNull(destFieldName, "The field name for which the mapping has to be removed cannot be null!");
        ((TransformerSettings)this.settings).getFieldsNameMapping().remove(destFieldName);
    }

    @Override
    public final void resetFieldsMapping() {
        ((TransformerSettings)this.settings).getFieldsNameMapping().clear();
    }

    @Override
    public final void removeFieldTransformer(String destFieldName) {
        Validator.notNull(destFieldName, "The field name for which the transformer function has to be removed cannot be null!");
        ((TransformerSettings)this.settings).getFieldsTransformers().remove(destFieldName);
        this.cacheManager.removeMatchingKeys(this.transformerFunctionRegex + destFieldName);
    }

    @Override
    public final void resetFieldsTransformer() {
        ((TransformerSettings)this.settings).getFieldsTransformers().clear();
        this.cacheManager.removeMatchingKeys(this.transformerFunctionRegex);
    }

    @Generated
    public S getSettings() {
        return this.settings;
    }
}

