/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.transformer.model;

import com.hotels.transformer.error.InvalidFunctionException;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;

public class FieldTransformer<T, K> {
    private final String destFieldName;
    private final Function<T, K> transformerFunction;
    private final Supplier<K> transformerSupplier;

    public FieldTransformer(String destinationFieldName, Function<T, K> fieldTransformerFunction) {
        this(destinationFieldName, fieldTransformerFunction, null);
    }

    public FieldTransformer(String destinationFieldName, Supplier<K> fieldTransformerSupplier) {
        this(destinationFieldName, null, fieldTransformerSupplier);
    }

    public final K getTransformedObject(T objectToTransform) {
        try {
            return Objects.nonNull(this.transformerFunction) ? this.transformerFunction.apply(objectToTransform) : this.transformerSupplier.get();
        }
        catch (Exception e) {
            throw new InvalidFunctionException("The transformer function defined for the field is not valid.", e);
        }
    }

    @ConstructorProperties(value={"destFieldName", "transformerFunction", "transformerSupplier"})
    @Generated
    private FieldTransformer(String destFieldName, Function<T, K> transformerFunction, Supplier<K> transformerSupplier) {
        this.destFieldName = destFieldName;
        this.transformerFunction = transformerFunction;
        this.transformerSupplier = transformerSupplier;
    }

    @Generated
    public String getDestFieldName() {
        return this.destFieldName;
    }

    @Generated
    public Function<T, K> getTransformerFunction() {
        return this.transformerFunction;
    }

    @Generated
    public Supplier<K> getTransformerSupplier() {
        return this.transformerSupplier;
    }

    @Generated
    public String toString() {
        return "FieldTransformer(destFieldName=" + this.getDestFieldName() + ", transformerFunction=" + this.getTransformerFunction() + ", transformerSupplier=" + this.getTransformerSupplier() + ")";
    }
}

