/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beans.conversion.processor.impl;

import com.hotels.beans.conversion.error.TypeConversionException;
import com.hotels.beans.conversion.processor.ConversionProcessor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.function.Function;

public final class BigDecimalConversionProcessor
implements ConversionProcessor<BigDecimal> {
    @Override
    public Function<Byte, BigDecimal> convertByte() {
        return val -> BigDecimal.valueOf(val.doubleValue());
    }

    @Override
    public Function<byte[], BigDecimal> convertByteArray() {
        return val -> {
            try {
                return BigDecimal.valueOf(ByteBuffer.wrap(val).getDouble());
            }
            catch (BufferUnderflowException e) {
                throw new TypeConversionException("Not enough byte to represents a BigDecimal. At least 8 bytes are required.");
            }
        };
    }

    @Override
    public Function<Short, BigDecimal> convertShort() {
        return BigDecimal::valueOf;
    }

    @Override
    public Function<Integer, BigDecimal> convertInteger() {
        return BigDecimal::valueOf;
    }

    @Override
    public Function<Long, BigDecimal> convertLong() {
        return BigDecimal::valueOf;
    }

    @Override
    public Function<Float, BigDecimal> convertFloat() {
        return BigDecimal::valueOf;
    }

    @Override
    public Function<Double, BigDecimal> convertDouble() {
        return BigDecimal::valueOf;
    }

    @Override
    public Function<Character, BigDecimal> convertCharacter() {
        return val -> BigDecimal.valueOf(Character.getNumericValue(val.charValue()));
    }

    @Override
    public Function<Boolean, BigDecimal> convertBoolean() {
        return val -> BigDecimal.valueOf(val != false ? 1L : 0L);
    }

    @Override
    public Function<String, BigDecimal> convertString() {
        return BigDecimal::new;
    }

    @Override
    public Function<BigInteger, BigDecimal> convertBigInteger() {
        return val -> BigDecimal.valueOf(val.intValue());
    }

    @Override
    public Function<BigDecimal, BigDecimal> convertBigDecimal() {
        return val -> val;
    }
}

