/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beans.conversion.processor.impl;

import com.hotels.beans.conversion.error.TypeConversionException;
import com.hotels.beans.conversion.processor.ConversionProcessor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.function.Function;

public final class BigIntegerConversionProcessor
implements ConversionProcessor<BigInteger> {
    @Override
    public Function<Byte, BigInteger> convertByte() {
        return val -> BigInteger.valueOf(val.longValue());
    }

    @Override
    public Function<byte[], BigInteger> convertByteArray() {
        return val -> {
            try {
                return BigInteger.valueOf(ByteBuffer.wrap(val).getLong());
            }
            catch (BufferUnderflowException e) {
                throw new TypeConversionException("Not enough byte to represents a BigInteger. At least 8 bytes are required.");
            }
        };
    }

    @Override
    public Function<Short, BigInteger> convertShort() {
        return BigInteger::valueOf;
    }

    @Override
    public Function<Integer, BigInteger> convertInteger() {
        return BigInteger::valueOf;
    }

    @Override
    public Function<Long, BigInteger> convertLong() {
        return BigInteger::valueOf;
    }

    @Override
    public Function<Float, BigInteger> convertFloat() {
        return val -> BigInteger.valueOf(val.intValue());
    }

    @Override
    public Function<Double, BigInteger> convertDouble() {
        return val -> BigInteger.valueOf(val.intValue());
    }

    @Override
    public Function<Character, BigInteger> convertCharacter() {
        return val -> BigInteger.valueOf(Character.getNumericValue(val.charValue()));
    }

    @Override
    public Function<Boolean, BigInteger> convertBoolean() {
        return val -> BigInteger.valueOf(val != false ? 1L : 0L);
    }

    @Override
    public Function<String, BigInteger> convertString() {
        return BigInteger::new;
    }

    @Override
    public Function<BigInteger, BigInteger> convertBigInteger() {
        return val -> val;
    }

    @Override
    public Function<BigDecimal, BigInteger> convertBigDecimal() {
        return BigDecimal::toBigInteger;
    }
}

