/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beans.conversion.processor.impl;

import com.hotels.beans.conversion.processor.ConversionProcessor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Function;

public final class BooleanConversionProcessor
implements ConversionProcessor<Boolean> {
    @Override
    public Function<Byte, Boolean> convertByte() {
        return val -> val != 0;
    }

    @Override
    public Function<byte[], Boolean> convertByteArray() {
        return val -> val[0] != 0;
    }

    @Override
    public Function<Short, Boolean> convertShort() {
        return val -> val != 0;
    }

    @Override
    public Function<Integer, Boolean> convertInteger() {
        return val -> val != 0;
    }

    @Override
    public Function<Long, Boolean> convertLong() {
        return val -> val != 0L;
    }

    @Override
    public Function<Float, Boolean> convertFloat() {
        return val -> val.floatValue() != 0.0f;
    }

    @Override
    public Function<Double, Boolean> convertDouble() {
        return val -> val != 0.0;
    }

    @Override
    public Function<Character, Boolean> convertCharacter() {
        return val -> val.charValue() == 'T';
    }

    @Override
    public Function<Boolean, Boolean> convertBoolean() {
        return val -> val;
    }

    @Override
    public Function<String, Boolean> convertString() {
        return Boolean::valueOf;
    }

    @Override
    public Function<BigInteger, Boolean> convertBigInteger() {
        return val -> val.intValue() != 0;
    }

    @Override
    public Function<BigDecimal, Boolean> convertBigDecimal() {
        return val -> val.intValue() != 0;
    }
}

