/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beans.conversion.processor.impl;

import com.hotels.beans.conversion.error.TypeConversionException;
import com.hotels.beans.conversion.processor.ConversionProcessor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.function.Function;

public final class CharacterConversionProcessor
implements ConversionProcessor<Character> {
    @Override
    public Function<Byte, Character> convertByte() {
        return val -> Character.valueOf((char)val.byteValue());
    }

    @Override
    public Function<byte[], Character> convertByteArray() {
        return val -> {
            try {
                return Character.valueOf(ByteBuffer.wrap(val).getChar());
            }
            catch (BufferUnderflowException e) {
                throw new TypeConversionException("Not enough byte to represents a Char. At least 2 bytes are required.");
            }
        };
    }

    @Override
    public Function<Short, Character> convertShort() {
        return val -> Character.valueOf((char)val.shortValue());
    }

    @Override
    public Function<Integer, Character> convertInteger() {
        return val -> Character.valueOf((char)val.intValue());
    }

    @Override
    public Function<Long, Character> convertLong() {
        return val -> Character.valueOf((char)val.longValue());
    }

    @Override
    public Function<Float, Character> convertFloat() {
        return val -> Character.valueOf((char)val.floatValue());
    }

    @Override
    public Function<Double, Character> convertDouble() {
        return val -> Character.valueOf((char)val.doubleValue());
    }

    @Override
    public Function<Character, Character> convertCharacter() {
        return val -> val;
    }

    @Override
    public Function<Boolean, Character> convertBoolean() {
        return val -> Character.valueOf(val != false ? (char)'T' : (char)'F');
    }

    @Override
    public Function<String, Character> convertString() {
        return val -> Character.valueOf(val.charAt(0));
    }

    @Override
    public Function<BigInteger, Character> convertBigInteger() {
        return val -> Character.valueOf((char)val.intValue());
    }

    @Override
    public Function<BigDecimal, Character> convertBigDecimal() {
        return val -> Character.valueOf((char)val.doubleValue());
    }
}

