/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beans.conversion.processor.impl;

import com.hotels.beans.conversion.error.TypeConversionException;
import com.hotels.beans.conversion.processor.ConversionProcessor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.function.Function;

public final class DoubleConversionProcessor
implements ConversionProcessor<Double> {
    @Override
    public Function<Byte, Double> convertByte() {
        return Byte::doubleValue;
    }

    @Override
    public Function<byte[], Double> convertByteArray() {
        return val -> {
            try {
                return ByteBuffer.wrap(val).getDouble();
            }
            catch (BufferUnderflowException e) {
                throw new TypeConversionException("Not enough byte to represents a Double. At least 8 bytes are required.");
            }
        };
    }

    @Override
    public Function<Short, Double> convertShort() {
        return Short::doubleValue;
    }

    @Override
    public Function<Integer, Double> convertInteger() {
        return Integer::doubleValue;
    }

    @Override
    public Function<Long, Double> convertLong() {
        return Long::doubleValue;
    }

    @Override
    public Function<Float, Double> convertFloat() {
        return Float::doubleValue;
    }

    @Override
    public Function<Double, Double> convertDouble() {
        return val -> val;
    }

    @Override
    public Function<Character, Double> convertCharacter() {
        return val -> Character.getNumericValue(val.charValue());
    }

    @Override
    public Function<Boolean, Double> convertBoolean() {
        return val -> val != false ? 1.0 : 0.0;
    }

    @Override
    public Function<String, Double> convertString() {
        return Double::valueOf;
    }

    @Override
    public Function<BigInteger, Double> convertBigInteger() {
        return BigInteger::doubleValue;
    }

    @Override
    public Function<BigDecimal, Double> convertBigDecimal() {
        return BigDecimal::doubleValue;
    }
}

