/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beans.conversion.processor.impl;

import com.hotels.beans.conversion.error.TypeConversionException;
import com.hotels.beans.conversion.processor.ConversionProcessor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.function.Function;

public final class FloatConversionProcessor
implements ConversionProcessor<Float> {
    @Override
    public Function<Byte, Float> convertByte() {
        return Byte::floatValue;
    }

    @Override
    public Function<byte[], Float> convertByteArray() {
        return val -> {
            try {
                return Float.valueOf(ByteBuffer.wrap(val).getFloat());
            }
            catch (BufferUnderflowException e) {
                throw new TypeConversionException("Not enough byte to represents a Float. At least 4 bytes are required.");
            }
        };
    }

    @Override
    public Function<Short, Float> convertShort() {
        return Short::floatValue;
    }

    @Override
    public Function<Integer, Float> convertInteger() {
        return Integer::floatValue;
    }

    @Override
    public Function<Long, Float> convertLong() {
        return Long::floatValue;
    }

    @Override
    public Function<Float, Float> convertFloat() {
        return val -> val;
    }

    @Override
    public Function<Double, Float> convertDouble() {
        return Double::floatValue;
    }

    @Override
    public Function<Character, Float> convertCharacter() {
        return val -> Float.valueOf(Character.getNumericValue(val.charValue()));
    }

    @Override
    public Function<Boolean, Float> convertBoolean() {
        return val -> Float.valueOf(val != false ? 1.0f : 0.0f);
    }

    @Override
    public Function<String, Float> convertString() {
        return Float::valueOf;
    }

    @Override
    public Function<BigInteger, Float> convertBigInteger() {
        return BigInteger::floatValue;
    }

    @Override
    public Function<BigDecimal, Float> convertBigDecimal() {
        return BigDecimal::floatValue;
    }
}

