/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beans.conversion.processor.impl;

import com.hotels.beans.conversion.error.TypeConversionException;
import com.hotels.beans.conversion.processor.ConversionProcessor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.function.Function;

public final class ShortConversionProcessor
implements ConversionProcessor<Short> {
    @Override
    public Function<Byte, Short> convertByte() {
        return Byte::shortValue;
    }

    @Override
    public Function<byte[], Short> convertByteArray() {
        return val -> {
            try {
                return ByteBuffer.wrap(val).getShort();
            }
            catch (BufferUnderflowException e) {
                throw new TypeConversionException("Not enough byte to represents a Short. At least 2 bytes are required.");
            }
        };
    }

    @Override
    public Function<Short, Short> convertShort() {
        return val -> val;
    }

    @Override
    public Function<Integer, Short> convertInteger() {
        return Integer::shortValue;
    }

    @Override
    public Function<Long, Short> convertLong() {
        return Long::shortValue;
    }

    @Override
    public Function<Float, Short> convertFloat() {
        return Float::shortValue;
    }

    @Override
    public Function<Double, Short> convertDouble() {
        return Double::shortValue;
    }

    @Override
    public Function<Character, Short> convertCharacter() {
        return val -> (short)Character.getNumericValue(val.charValue());
    }

    @Override
    public Function<Boolean, Short> convertBoolean() {
        return val -> val != false ? (short)1 : (short)0;
    }

    @Override
    public Function<String, Short> convertString() {
        return Short::valueOf;
    }

    @Override
    public Function<BigInteger, Short> convertBigInteger() {
        return Number::shortValue;
    }

    @Override
    public Function<BigDecimal, Short> convertBigDecimal() {
        return Number::shortValue;
    }
}

