/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beans.conversion;

import com.hotels.beans.conversion.Converter;
import com.hotels.beans.conversion.analyzer.ConversionAnalyzer;
import com.hotels.beans.conversion.error.TypeConversionException;
import com.hotels.transformer.validator.Validator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class ConverterImpl
implements Converter {
    private final ConversionAnalyzer conversionAnalyzer = new ConversionAnalyzer();

    @Override
    public Optional<Function<Object, Object>> getConversionFunction(Class<?> sourceClass, Class<?> targetClass) {
        return this.conversionAnalyzer.getConversionFunction(sourceClass, targetClass);
    }

    @Override
    public <T, K> K convertValue(T valueToConvert, Class<K> targetClass) {
        Validator.notNull(targetClass, (String)"The destination field type cannot be null.");
        if (Objects.isNull(valueToConvert)) {
            return null;
        }
        if (targetClass.getSimpleName().equalsIgnoreCase(valueToConvert.getClass().getSimpleName())) {
            return (K)valueToConvert;
        }
        return (K)this.getConversionFunction(valueToConvert.getClass(), targetClass).map(processor -> processor.apply(valueToConvert)).orElseThrow(() -> new TypeConversionException("No converter available for type: " + targetClass.getName()));
    }
}

