/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beans.conversion.processor.impl;

import com.hotels.beans.conversion.processor.ConversionProcessor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Function;

public final class ByteConversionProcessor
implements ConversionProcessor<Byte> {
    @Override
    public Function<Byte, Byte> convertByte() {
        return val -> val;
    }

    @Override
    public Function<byte[], Byte> convertByteArray() {
        return val -> val[0];
    }

    @Override
    public Function<Short, Byte> convertShort() {
        return Short::byteValue;
    }

    @Override
    public Function<Integer, Byte> convertInteger() {
        return Integer::byteValue;
    }

    @Override
    public Function<Long, Byte> convertLong() {
        return Long::byteValue;
    }

    @Override
    public Function<Float, Byte> convertFloat() {
        return Float::byteValue;
    }

    @Override
    public Function<Double, Byte> convertDouble() {
        return Double::byteValue;
    }

    @Override
    public Function<Character, Byte> convertCharacter() {
        return val -> (byte)val.charValue();
    }

    @Override
    public Function<Boolean, Byte> convertBoolean() {
        return val -> Boolean.TRUE.equals(val) ? (byte)1 : (byte)0;
    }

    @Override
    public Function<String, Byte> convertString() {
        return Byte::valueOf;
    }

    @Override
    public Function<BigInteger, Byte> convertBigInteger() {
        return Number::byteValue;
    }

    @Override
    public Function<BigDecimal, Byte> convertBigDecimal() {
        return Number::byteValue;
    }
}

