/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beans.conversion.processor.impl;

import com.hotels.beans.conversion.error.TypeConversionException;
import com.hotels.beans.conversion.processor.ConversionProcessor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.function.Function;

public final class LongConversionProcessor
implements ConversionProcessor<Long> {
    @Override
    public Function<Byte, Long> convertByte() {
        return Byte::longValue;
    }

    @Override
    public Function<byte[], Long> convertByteArray() {
        return val -> {
            try {
                return ByteBuffer.wrap(val).getLong();
            }
            catch (BufferUnderflowException e) {
                throw new TypeConversionException("Not enough byte to represents a Long. At least 8 bytes are required.");
            }
        };
    }

    @Override
    public Function<Short, Long> convertShort() {
        return Short::longValue;
    }

    @Override
    public Function<Integer, Long> convertInteger() {
        return Integer::longValue;
    }

    @Override
    public Function<Long, Long> convertLong() {
        return Long::longValue;
    }

    @Override
    public Function<Float, Long> convertFloat() {
        return Float::longValue;
    }

    @Override
    public Function<Double, Long> convertDouble() {
        return Double::longValue;
    }

    @Override
    public Function<Character, Long> convertCharacter() {
        return val -> Character.getNumericValue(val.charValue());
    }

    @Override
    public Function<Boolean, Long> convertBoolean() {
        return val -> Boolean.TRUE.equals(val) ? 1L : 0L;
    }

    @Override
    public Function<String, Long> convertString() {
        return Long::valueOf;
    }

    @Override
    public Function<BigInteger, Long> convertBigInteger() {
        return BigInteger::longValue;
    }

    @Override
    public Function<BigDecimal, Long> convertBigDecimal() {
        return BigDecimal::longValue;
    }
}

