/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beans.conversion.processor;

import com.hotels.beans.conversion.processor.ConversionProcessor;
import com.hotels.beans.conversion.processor.impl.BigDecimalConversionProcessor;
import com.hotels.beans.conversion.processor.impl.BigIntegerConversionProcessor;
import com.hotels.beans.conversion.processor.impl.BooleanConversionProcessor;
import com.hotels.beans.conversion.processor.impl.ByteArrayConversionProcessor;
import com.hotels.beans.conversion.processor.impl.ByteConversionProcessor;
import com.hotels.beans.conversion.processor.impl.CharacterConversionProcessor;
import com.hotels.beans.conversion.processor.impl.DoubleConversionProcessor;
import com.hotels.beans.conversion.processor.impl.FloatConversionProcessor;
import com.hotels.beans.conversion.processor.impl.IntegerConversionProcessor;
import com.hotels.beans.conversion.processor.impl.LongConversionProcessor;
import com.hotels.beans.conversion.processor.impl.ShortConversionProcessor;
import com.hotels.beans.conversion.processor.impl.StringConversionProcessor;
import com.hotels.transformer.utils.ClassUtils;
import java.util.Optional;
import lombok.Generated;

public final class ConversionProcessorFactory {
    public static Optional<ConversionProcessor> getConversionProcessor(Class<?> clazz) {
        Optional<ConversionProcessor> conversionProcessor = Optional.empty();
        if (ClassUtils.isByte(clazz)) {
            conversionProcessor = Optional.of(new ByteConversionProcessor());
        } else if (ClassUtils.isShort(clazz)) {
            conversionProcessor = Optional.of(new ShortConversionProcessor());
        } else if (ClassUtils.isInt(clazz)) {
            conversionProcessor = Optional.of(new IntegerConversionProcessor());
        } else if (ClassUtils.isLong(clazz)) {
            conversionProcessor = Optional.of(new LongConversionProcessor());
        } else if (ClassUtils.isFloat(clazz)) {
            conversionProcessor = Optional.of(new FloatConversionProcessor());
        } else if (ClassUtils.isDouble(clazz)) {
            conversionProcessor = Optional.of(new DoubleConversionProcessor());
        } else if (ClassUtils.isChar(clazz)) {
            conversionProcessor = Optional.of(new CharacterConversionProcessor());
        } else if (ClassUtils.isString(clazz)) {
            conversionProcessor = Optional.of(new StringConversionProcessor());
        } else if (ClassUtils.isBoolean(clazz)) {
            conversionProcessor = Optional.of(new BooleanConversionProcessor());
        } else if (ClassUtils.isBigInteger(clazz)) {
            conversionProcessor = Optional.of(new BigIntegerConversionProcessor());
        } else if (ClassUtils.isBigDecimal(clazz)) {
            conversionProcessor = Optional.of(new BigDecimalConversionProcessor());
        } else if (ClassUtils.isByteArray(clazz)) {
            conversionProcessor = Optional.of(new ByteArrayConversionProcessor());
        }
        return conversionProcessor;
    }

    @Generated
    private ConversionProcessorFactory() {
    }
}

