/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beans.conversion.processor.impl;

import com.hotels.beans.conversion.error.TypeConversionException;
import com.hotels.beans.conversion.processor.ConversionProcessor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.function.Function;

public final class IntegerConversionProcessor
implements ConversionProcessor<Integer> {
    @Override
    public Function<Byte, Integer> convertByte() {
        return Byte::intValue;
    }

    @Override
    public Function<byte[], Integer> convertByteArray() {
        return val -> {
            try {
                return ByteBuffer.wrap(val).getInt();
            }
            catch (BufferUnderflowException e) {
                throw new TypeConversionException("Not enough byte to represents an Integer. At least 4 bytes are required.");
            }
        };
    }

    @Override
    public Function<Short, Integer> convertShort() {
        return Short::intValue;
    }

    @Override
    public Function<Integer, Integer> convertInteger() {
        return val -> val;
    }

    @Override
    public Function<Long, Integer> convertLong() {
        return Long::intValue;
    }

    @Override
    public Function<Float, Integer> convertFloat() {
        return Float::intValue;
    }

    @Override
    public Function<Double, Integer> convertDouble() {
        return Double::intValue;
    }

    @Override
    public Function<Character, Integer> convertCharacter() {
        return Character::getNumericValue;
    }

    @Override
    public Function<Boolean, Integer> convertBoolean() {
        return val -> Boolean.TRUE.equals(val) ? 1 : 0;
    }

    @Override
    public Function<String, Integer> convertString() {
        return Integer::valueOf;
    }

    @Override
    public Function<BigInteger, Integer> convertBigInteger() {
        return BigInteger::intValue;
    }

    @Override
    public Function<BigDecimal, Integer> convertBigDecimal() {
        return BigDecimal::intValue;
    }
}

