/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beans.conversion.analyzer;

import com.hotels.beans.conversion.processor.ConversionProcessor;
import com.hotels.beans.conversion.processor.ConversionProcessorFactory;
import com.hotels.transformer.cache.CacheManager;
import com.hotels.transformer.cache.CacheManagerFactory;
import com.hotels.transformer.utils.ClassUtils;
import java.util.Optional;
import java.util.function.Function;

public final class ConversionAnalyzer {
    private static final CacheManager CACHE_MANAGER = CacheManagerFactory.getCacheManager((String)"conversionAnalyzer");
    private final ClassUtils classUtils = new ClassUtils();

    public Optional<Function<Object, Object>> getConversionFunction(Class<?> sourceClass, Class<?> targetClass) {
        String cacheKey = "ConversionFunction-" + sourceClass.getName() + "-" + targetClass.getName();
        return CACHE_MANAGER.getFromCache(cacheKey, Optional.class).orElseGet(() -> {
            Optional<Object> conversionFunction = Optional.empty();
            if (!targetClass.getSimpleName().equalsIgnoreCase(sourceClass.getSimpleName()) && (this.classUtils.isPrimitiveType(sourceClass) || this.classUtils.isPrimitiveTypeArray(sourceClass))) {
                conversionFunction = ConversionProcessorFactory.getConversionProcessor(targetClass).flatMap(cp -> this.getTypeConversionFunction((ConversionProcessor)cp, sourceClass));
            }
            CACHE_MANAGER.cacheObject(cacheKey, conversionFunction);
            return conversionFunction;
        });
    }

    private Optional<Function<?, ?>> getTypeConversionFunction(ConversionProcessor conversionProcessor, Class<?> sourceFieldType) {
        Optional<Object> conversionFunction = Optional.empty();
        if (ClassUtils.isString(sourceFieldType)) {
            conversionFunction = Optional.of(conversionProcessor.convertString());
        } else if (ClassUtils.isByte(sourceFieldType)) {
            conversionFunction = Optional.of(conversionProcessor.convertByte());
        } else if (ClassUtils.isShort(sourceFieldType)) {
            conversionFunction = Optional.of(conversionProcessor.convertShort());
        } else if (ClassUtils.isInt(sourceFieldType)) {
            conversionFunction = Optional.of(conversionProcessor.convertInteger());
        } else if (ClassUtils.isLong(sourceFieldType)) {
            conversionFunction = Optional.of(conversionProcessor.convertLong());
        } else if (ClassUtils.isFloat(sourceFieldType)) {
            conversionFunction = Optional.of(conversionProcessor.convertFloat());
        } else if (ClassUtils.isDouble(sourceFieldType)) {
            conversionFunction = Optional.of(conversionProcessor.convertDouble());
        } else if (ClassUtils.isChar(sourceFieldType)) {
            conversionFunction = Optional.of(conversionProcessor.convertCharacter());
        } else if (ClassUtils.isBoolean(sourceFieldType)) {
            conversionFunction = Optional.of(conversionProcessor.convertBoolean());
        } else if (ClassUtils.isBigInteger(sourceFieldType)) {
            conversionFunction = Optional.of(conversionProcessor.convertBigInteger());
        } else if (ClassUtils.isBigDecimal(sourceFieldType)) {
            conversionFunction = Optional.of(conversionProcessor.convertBigDecimal());
        } else if (ClassUtils.isByteArray(sourceFieldType)) {
            conversionFunction = Optional.of(conversionProcessor.convertByteArray());
        }
        return conversionFunction;
    }
}

