/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beeju;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.thrift.TException;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;

abstract class BeejuJUnitRule
extends ExternalResource {
    public static final String METASTORE_DB_USER = "db_user";
    public static final String METASTORE_DB_PASSWORD = "db_password";
    @VisibleForTesting
    final TemporaryFolder temporaryFolder = new TemporaryFolder();
    protected final HiveConf conf = new HiveConf();
    private final String databaseName;
    private final String connectionURL;
    private final String driverClassName;
    private File metastoreLocation;

    public BeejuJUnitRule(String databaseName, Map<String, String> configuration) {
        Preconditions.checkNotNull((Object)databaseName, (Object)"databaseName is required");
        this.databaseName = databaseName;
        if (configuration != null && !configuration.isEmpty()) {
            for (Map.Entry<String, String> entry : configuration.entrySet()) {
                this.conf.set(entry.getKey(), entry.getValue());
            }
        }
        this.driverClassName = EmbeddedDriver.class.getName();
        this.conf.setBoolean("hcatalog.hive.client.cache.disabled", true);
        this.connectionURL = "jdbc:derby:memory:" + UUID.randomUUID() + ";create=true";
        this.conf.setVar(HiveConf.ConfVars.METASTORECONNECTURLKEY, this.connectionURL);
        this.conf.setVar(HiveConf.ConfVars.METASTORE_CONNECTION_DRIVER, this.driverClassName);
        this.conf.setVar(HiveConf.ConfVars.METASTORE_CONNECTION_USER_NAME, METASTORE_DB_USER);
        this.conf.setVar(HiveConf.ConfVars.METASTOREPWD, METASTORE_DB_PASSWORD);
        this.conf.setBoolVar(HiveConf.ConfVars.HMSHANDLERFORCERELOADCONF, true);
        this.conf.setBoolean("datanucleus.schema.autoCreateAll", true);
        this.conf.setBoolean("hive.metastore.schema.verification", false);
        this.conf.setInt("hive.server2.webui.port", 0);
        try {
            String derbyLog = File.createTempFile("derby", ".log").getCanonicalPath();
            System.setProperty("derby.stream.error.file", derbyLog);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void init() throws Throwable {
        this.metastoreLocation = this.temporaryFolder.newFolder("metastore");
        this.conf.setVar(HiveConf.ConfVars.METASTOREWAREHOUSE, this.metastoreLocation.getAbsolutePath());
    }

    protected abstract void beforeTest() throws Throwable;

    protected void before() throws Throwable {
        this.temporaryFolder.create();
        this.init();
        this.beforeTest();
        this.createDatabase(this.databaseName);
    }

    protected abstract void afterTest();

    protected void after() {
        this.afterTest();
        this.temporaryFolder.delete();
    }

    public String driverClassName() {
        return this.driverClassName;
    }

    public HiveConf conf() {
        return new HiveConf(this.conf);
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String connectionURL() {
        return this.connectionURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDatabase(String databaseName) throws TException {
        String databaseFolder = new File(this.temporaryFolder.getRoot(), databaseName).toURI().toString();
        try (HiveMetaStoreClient client = new HiveMetaStoreClient(this.conf());){
            client.createDatabase(new Database(databaseName, null, databaseFolder, null));
        }
    }
}

