/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beeju;

import com.hotels.beeju.BeejuJUnitRule;
import com.hotels.beeju.hiveserver2.RelaxedSQLStdHiveAuthorizerFactory;
import java.net.ServerSocket;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hive.jdbc.HiveDriver;
import org.apache.hive.service.Service;
import org.apache.hive.service.server.HiveServer2;

public class HiveServer2JUnitRule
extends BeejuJUnitRule {
    private String jdbcConnectionUrl;
    private HiveServer2 hiveServer2;
    private int port;

    public HiveServer2JUnitRule() {
        this("test_database");
    }

    public HiveServer2JUnitRule(String databaseName) {
        this(databaseName, null);
    }

    public HiveServer2JUnitRule(String databaseName, Map<String, String> configuration) {
        super(databaseName, configuration);
    }

    @Override
    protected void init() throws Throwable {
        super.init();
        try (ServerSocket socket = new ServerSocket(0);){
            this.port = socket.getLocalPort();
        }
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT, this.port);
    }

    @Override
    protected void beforeTest() throws Throwable {
        this.conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, RelaxedSQLStdHiveAuthorizerFactory.class.getName());
        this.hiveServer2 = new HiveServer2();
        this.hiveServer2.init(this.conf);
        this.hiveServer2.start();
        this.waitForHiveServer2StartUp();
        this.jdbcConnectionUrl = "jdbc:hive2://localhost:" + this.port + "/" + this.databaseName();
    }

    private void waitForHiveServer2StartUp() throws InterruptedException {
        int retries;
        int maxRetries = 5;
        for (retries = 0; this.hiveServer2.getServiceState() != Service.STATE.STARTED && retries < maxRetries; ++retries) {
            Thread.sleep(1000L);
        }
        if (retries >= maxRetries) {
            throw new RuntimeException("HiveServer2 did not start in a reasonable time");
        }
    }

    @Override
    protected void afterTest() {
        if (this.hiveServer2 != null) {
            this.hiveServer2.stop();
        }
    }

    @Override
    public String driverClassName() {
        return HiveDriver.class.getName();
    }

    @Override
    public String connectionURL() {
        return this.jdbcConnectionUrl;
    }

    public HiveMetaStoreClient newClient() {
        try {
            return new HiveMetaStoreClient(this.conf());
        }
        catch (MetaException e) {
            throw new RuntimeException("Unable to create HiveMetaStoreClient", e);
        }
    }
}

