/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beeju;

import com.hotels.beeju.HiveMetaStoreJUnitRule;
import java.net.ServerSocket;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge23;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftHiveMetaStoreJUnitRule
extends HiveMetaStoreJUnitRule {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftHiveMetaStoreJUnitRule.class);
    private final ExecutorService thriftServer = Executors.newSingleThreadExecutor();
    private int thriftPort;

    public ThriftHiveMetaStoreJUnitRule() {
        this("test_database");
    }

    public ThriftHiveMetaStoreJUnitRule(String databaseName) {
        this(databaseName, null);
    }

    public ThriftHiveMetaStoreJUnitRule(String databaseName, Map<String, String> configuration) {
        super(databaseName, configuration);
    }

    @Override
    protected void beforeTest() throws Throwable {
        this.thriftPort = -1;
        this.startThrift();
        super.beforeTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThrift() throws Exception {
        final ReentrantLock startLock = new ReentrantLock();
        final Condition startCondition = startLock.newCondition();
        final AtomicBoolean startedServing = new AtomicBoolean();
        try (ServerSocket socket = new ServerSocket(0);){
            this.thriftPort = socket.getLocalPort();
        }
        this.conf.setVar(HiveConf.ConfVars.METASTOREURIS, this.getThriftConnectionUri());
        final HiveConf hiveConf = new HiveConf((Configuration)this.conf, HiveMetaStoreClient.class);
        this.thriftServer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    HadoopThriftAuthBridge23 bridge = new HadoopThriftAuthBridge23();
                    HiveMetaStore.startMetaStore((int)ThriftHiveMetaStoreJUnitRule.this.thriftPort, (HadoopThriftAuthBridge)bridge, (HiveConf)hiveConf, (Lock)startLock, (Condition)startCondition, (AtomicBoolean)startedServing);
                }
                catch (Throwable e) {
                    LOG.error("Unable to start a Thrift server for Hive Metastore", e);
                }
            }
        });
        int i = 0;
        while (i++ < 3) {
            startLock.lock();
            try {
                if (startCondition.await(1L, TimeUnit.MINUTES)) {
                    break;
                }
            }
            finally {
                startLock.unlock();
            }
            if (i != 3) continue;
            throw new RuntimeException("Maximum number of tries reached whilst waiting for Thrift server to be ready");
        }
    }

    public String getThriftConnectionUri() {
        return "thrift://localhost:" + this.thriftPort;
    }

    public int getThriftPort() {
        return this.thriftPort;
    }

    @Override
    protected void afterTest() {
        this.thriftServer.shutdown();
        super.afterTest();
    }
}

