/**
 * Copyright (C) ${license.git.copyrightYears} Expedia, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hotels.bdp.circustrain.core;

import org.apache.hadoop.hive.metastore.IMetaStoreClient;

public interface PartitionPredicate {

  /**
   * @return partition predicate string that can be use as a filter in
   *         {@link IMetaStoreClient#listPartitionsByFilter(String, String, String, short)}
   */
  String getPartitionPredicate();

  /**
   * @return limit to be used in the fetching of partitions
   */
  short getPartitionPredicateLimit();

}
