/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.hotels.bdp.circustrain.CircusTrainHelp;
import com.hotels.bdp.circustrain.ConfigFileValidationApplicationListener;
import com.hotels.bdp.circustrain.ConfigFileValidationException;
import com.hotels.bdp.circustrain.api.copier.CopierFactoryManager;
import com.hotels.bdp.circustrain.api.copier.CopierOptions;
import com.hotels.bdp.circustrain.api.data.DataManipulatorFactoryManager;
import com.hotels.bdp.circustrain.api.event.CopierListener;
import com.hotels.bdp.circustrain.api.event.LocomotiveListener;
import com.hotels.bdp.circustrain.api.event.ReplicaCatalogListener;
import com.hotels.bdp.circustrain.api.event.SourceCatalogListener;
import com.hotels.bdp.circustrain.api.event.TableReplicationListener;
import com.hotels.bdp.circustrain.api.listener.HousekeepingListener;
import com.hotels.bdp.circustrain.api.metadata.ColumnStatisticsTransformation;
import com.hotels.bdp.circustrain.api.metadata.PartitionTransformation;
import com.hotels.bdp.circustrain.api.metadata.TableTransformation;
import com.hotels.bdp.circustrain.api.metrics.LoggingScheduledReporterFactory;
import com.hotels.bdp.circustrain.api.metrics.MetricSender;
import com.hotels.bdp.circustrain.api.metrics.ScheduledReporterFactory;
import com.hotels.bdp.circustrain.comparator.hive.functions.PathDigest;
import com.hotels.bdp.circustrain.comparator.hive.functions.PathToPathMetadata;
import com.hotels.bdp.circustrain.core.PartitionPredicateFactory;
import com.hotels.bdp.circustrain.core.ReplicationFactory;
import com.hotels.bdp.circustrain.core.ReplicationFactoryImpl;
import com.hotels.bdp.circustrain.core.StrategyBasedReplicationFactory;
import com.hotels.bdp.circustrain.core.conf.SpringExpressionParser;
import com.hotels.bdp.circustrain.core.event.CompositeCopierListener;
import com.hotels.bdp.circustrain.core.event.CompositeLocomotiveListener;
import com.hotels.bdp.circustrain.core.event.CompositeReplicaCatalogListener;
import com.hotels.bdp.circustrain.core.event.CompositeSourceCatalogListener;
import com.hotels.bdp.circustrain.core.event.CompositeTableReplicationListener;
import com.hotels.bdp.circustrain.core.replica.ReplicaFactory;
import com.hotels.bdp.circustrain.core.source.SourceFactory;
import com.hotels.bdp.circustrain.core.transformation.CompositePartitionTransformation;
import com.hotels.bdp.circustrain.core.transformation.CompositeTableTransformation;
import com.hotels.bdp.circustrain.extension.ExtensionInitializer;
import com.hotels.bdp.circustrain.manifest.ManifestAttributes;
import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Profile;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;

@SpringBootApplication
@EnableRetry
@EnableConfigurationProperties
@ComponentScan(basePackages={"com.hotels.bdp.circustrain.avro", "com.hotels.bdp.circustrain.aws", "com.hotels.bdp.circustrain.context", "com.hotels.bdp.circustrain.core", "com.hotels.bdp.circustrain.distcpcopier", "com.hotels.bdp.circustrain.gcp", "com.hotels.bdp.circustrain.hive.view.transformation", "com.hotels.bdp.circustrain.housekeeping", "com.hotels.bdp.circustrain.metrics.conf", "com.hotels.bdp.circustrain.s3mapreducecpcopier", "com.hotels.bdp.circustrain.s3s3copier"})
public class CircusTrain {
    private static final Logger LOG = LoggerFactory.getLogger(CircusTrain.class);

    public static void main(String[] args) throws Exception {
        int exitCode;
        block3: {
            CircusTrain.logVersionInfo();
            exitCode = -1;
            try {
                String defaultModules = Joiner.on((String)",").join((Object)"replication", (Object)"housekeeping", new Object[0]);
                exitCode = SpringApplication.exit((ApplicationContext)new SpringApplicationBuilder(new Object[]{CircusTrain.class}).properties(new String[]{"spring.config.location:${config:null}"}).properties(new String[]{"spring.profiles.active:${modules:" + defaultModules + "}"}).properties(new String[]{"instance.home:${user.home}"}).properties(new String[]{"instance.name:${source-catalog.name}_${replica-catalog.name}"}).properties(new String[]{"jasypt.encryptor.password:${password:null}"}).properties(new String[]{"housekeeping.schema-name:circus_train"}).registerShutdownHook(true).initializers(new ApplicationContextInitializer[]{new ExtensionInitializer()}).listeners(new ApplicationListener[]{new ConfigFileValidationApplicationListener()}).build().run(args), (ExitCodeGenerator[])new ExitCodeGenerator[0]);
            }
            catch (ConfigFileValidationException e) {
                LOG.error(e.getMessage(), (Throwable)((Object)e));
                CircusTrain.printCircusTrainHelp(e.getErrors());
            }
            catch (BeanCreationException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                Throwable mostSpecificCause = e.getMostSpecificCause();
                if (!(mostSpecificCause instanceof BindException)) break block3;
                CircusTrain.printCircusTrainHelp(((BindException)mostSpecificCause).getAllErrors());
            }
        }
        System.exit(exitCode);
    }

    private static void printCircusTrainHelp(List<ObjectError> allErrors) {
        System.out.println(new CircusTrainHelp(allErrors));
    }

    CircusTrain() {
        CircusTrain.logVersionInfo();
    }

    private static void logVersionInfo() {
        ManifestAttributes manifestAttributes = new ManifestAttributes(CircusTrain.class);
        LOG.info("{}", (Object)manifestAttributes);
    }

    @Bean
    LocomotiveListener locomotiveListener(List<LocomotiveListener> listeners) {
        if (listeners == null) {
            listeners = Collections.emptyList();
        }
        return new CompositeLocomotiveListener(listeners);
    }

    @Bean
    SourceCatalogListener sourceCatalogListener(List<SourceCatalogListener> listeners) {
        if (listeners == null) {
            listeners = Collections.emptyList();
        }
        return new CompositeSourceCatalogListener(listeners);
    }

    @Bean
    ReplicaCatalogListener replicaCatalogListener(List<ReplicaCatalogListener> listeners) {
        if (listeners == null) {
            listeners = Collections.emptyList();
        }
        return new CompositeReplicaCatalogListener(listeners);
    }

    @Bean
    TableReplicationListener tableReplicationListener(List<TableReplicationListener> listeners) {
        if (listeners == null) {
            listeners = Collections.emptyList();
        }
        return new CompositeTableReplicationListener(listeners);
    }

    @Bean
    CopierListener copierListener(List<CopierListener> listeners) {
        if (listeners == null) {
            listeners = Collections.emptyList();
        }
        return new CompositeCopierListener(listeners);
    }

    @Profile(value={"replication"})
    @Bean
    TableTransformation tableTransformation(List<TableTransformation> transformations) {
        if (transformations == null) {
            transformations = Collections.emptyList();
        }
        return new CompositeTableTransformation(transformations);
    }

    @Profile(value={"replication"})
    @Bean
    PartitionTransformation partitionTransformation(List<PartitionTransformation> transformations) {
        if (transformations == null) {
            transformations = Collections.emptyList();
        }
        return new CompositePartitionTransformation(transformations);
    }

    @Bean
    @ConditionalOnMissingBean(value={ColumnStatisticsTransformation.class})
    ColumnStatisticsTransformation columnStatisticsTransformation() {
        return ColumnStatisticsTransformation.IDENTITY;
    }

    @Bean
    @ConditionalOnMissingBean(value={MetricSender.class})
    MetricSender metricSender() {
        return MetricSender.DEFAULT_LOG_ONLY;
    }

    @Bean
    @ConditionalOnMissingBean(value={ScheduledReporterFactory.class})
    ScheduledReporterFactory runningScheduledReporterFactory(MetricRegistry runningMetricRegistry) {
        return new LoggingScheduledReporterFactory(runningMetricRegistry);
    }

    @Bean
    MetricRegistry runningMetricRegistry() {
        return new MetricRegistry();
    }

    @Bean
    @ConditionalOnMissingBean(name={"housekeepingListener"})
    HousekeepingListener housekeepingListener() {
        return HousekeepingListener.NULL;
    }

    @Profile(value={"replication"})
    @Bean
    ReplicationFactory replicationFactory(SourceFactory sourceFactory, ReplicaFactory replicaFactory, CopierFactoryManager copierFactoryManager, CopierListener copierListener, PartitionPredicateFactory partitionPredicateFactory, CopierOptions copierOptions, Supplier<CloseableMetaStoreClient> sourceMetaStoreClientSupplier, Supplier<CloseableMetaStoreClient> replicaMetaStoreClientSupplier, HousekeepingListener housekeepingListener, ReplicaCatalogListener replicaCatalogListener, DataManipulatorFactoryManager dataManipulatorFactoryManager) {
        ReplicationFactoryImpl upsertReplicationFactory = new ReplicationFactoryImpl(sourceFactory, replicaFactory, copierFactoryManager, copierListener, partitionPredicateFactory, copierOptions, dataManipulatorFactoryManager);
        return new StrategyBasedReplicationFactory(upsertReplicationFactory, sourceMetaStoreClientSupplier, replicaMetaStoreClientSupplier, housekeepingListener, replicaCatalogListener);
    }

    @Profile(value={"replication"})
    @Bean
    PartitionPredicateFactory partitionPredicateFactory(SourceFactory sourceFactory, ReplicaFactory replicaFactory, SpringExpressionParser expressionParser, @Value(value="#{checksumFunction}") Function<Path, String> checksumFunction) {
        return new PartitionPredicateFactory(sourceFactory, replicaFactory, expressionParser, checksumFunction);
    }

    @Profile(value={"replication"})
    @Bean
    Function<Path, String> checksumFunction(HiveConf sourceHiveConf) {
        return Functions.compose((Function)new PathDigest(), (Function)new PathToPathMetadata((Configuration)sourceHiveConf));
    }
}

