/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.validation.ObjectError;

class CircusTrainHelp {
    private static final String TAB = "\t";
    static final Function<ObjectError, String> OBJECT_ERROR_TO_TABBED_MESSAGE = new Function<ObjectError, String>(){

        public String apply(@Nonnull ObjectError error) {
            return CircusTrainHelp.TAB + error.getDefaultMessage();
        }
    };
    private final List<ObjectError> errors;

    CircusTrainHelp(List<ObjectError> errors) {
        this.errors = errors;
    }

    public String toString() {
        FluentIterable errorMessages = FluentIterable.from(this.errors).transform(OBJECT_ERROR_TO_TABBED_MESSAGE);
        StringBuilder help = new StringBuilder(500).append("Usage: circus-train.sh --config=<config_file>[,<config_file>,...]").append(System.lineSeparator()).append("Errors found in the provided configuration file:").append(System.lineSeparator()).append(Joiner.on((String)System.lineSeparator()).join((Iterable)errorMessages)).append(System.lineSeparator()).append("Configuration file help:").append(System.lineSeparator()).append(TAB).append("For more information and help please refer to ").append("https://github.com/HotelsDotCom/circus-train/blob/master/README.md");
        return help.toString();
    }
}

