/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain;

import com.google.common.base.Splitter;
import com.hotels.bdp.circustrain.ConfigFileValidationException;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;

class ConfigFileValidationApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    ConfigFileValidationApplicationListener() {
    }

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        String configFilesString = event.getEnvironment().getProperty("spring.config.location");
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)configFilesString)) {
            errors.add("No config file was specified.");
        } else {
            for (String configFileString : Splitter.on((char)',').split((CharSequence)configFilesString)) {
                File configFile = new File(configFileString);
                if (!configFile.exists()) {
                    errors.add("Config file " + configFileString + " does not exist.");
                    continue;
                }
                if (!configFile.isFile()) {
                    errors.add("Config file " + configFileString + " is a directory.");
                    continue;
                }
                if (configFile.canRead()) continue;
                errors.add("Config file " + configFileString + " cannot be read.");
            }
        }
        if (!errors.isEmpty()) {
            throw new ConfigFileValidationException(errors);
        }
    }
}

