/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.context;

import com.google.common.base.Supplier;
import com.hotels.bdp.circustrain.api.conf.ReplicaCatalog;
import com.hotels.bdp.circustrain.api.conf.Security;
import com.hotels.bdp.circustrain.api.conf.SourceCatalog;
import com.hotels.bdp.circustrain.api.conf.TunnelMetastoreCatalog;
import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;
import com.hotels.hcommon.hive.metastore.client.api.ConditionalMetaStoreClientFactory;
import com.hotels.hcommon.hive.metastore.client.api.MetaStoreClientFactory;
import com.hotels.hcommon.hive.metastore.client.conditional.ConditionalMetaStoreClientFactoryManager;
import com.hotels.hcommon.hive.metastore.client.conditional.ThriftHiveMetaStoreClientFactory;
import com.hotels.hcommon.hive.metastore.client.supplier.HiveMetaStoreClientSupplier;
import com.hotels.hcommon.hive.metastore.client.tunnelling.MetastoreTunnel;
import com.hotels.hcommon.hive.metastore.client.tunnelling.TunnellingMetaStoreClientSupplierBuilder;
import com.hotels.hcommon.hive.metastore.conf.HiveConfFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
@Configuration
public class CommonBeans {
    private static final Logger LOG = LoggerFactory.getLogger(CommonBeans.class);
    public static final String BEAN_BASE_CONF = "baseConf";

    @Bean(name={"baseConf"})
    org.apache.hadoop.conf.Configuration baseConf(Security security) {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.setCredentialProviderPath(security, properties);
        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
        for (Map.Entry entry : properties.entrySet()) {
            conf.set((String)entry.getKey(), (String)entry.getValue());
        }
        return conf;
    }

    @Profile(value={"replication"})
    @Bean
    HiveConf sourceHiveConf(SourceCatalog sourceCatalog, @Qualifier(value="baseConf") org.apache.hadoop.conf.Configuration baseConf) {
        return this.newHiveConf((TunnelMetastoreCatalog)sourceCatalog, baseConf);
    }

    @Bean
    HiveConf replicaHiveConf(ReplicaCatalog replicaCatalog, @Qualifier(value="baseConf") org.apache.hadoop.conf.Configuration baseConf) {
        return this.newHiveConf((TunnelMetastoreCatalog)replicaCatalog, baseConf);
    }

    private HiveConf newHiveConf(TunnelMetastoreCatalog hiveCatalog, org.apache.hadoop.conf.Configuration baseConf) {
        List siteXml = hiveCatalog.getSiteXml();
        if (CollectionUtils.isEmpty((Collection)siteXml)) {
            LOG.info("No Hadoop site XML is defined for catalog {}.", (Object)hiveCatalog.getName());
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry entry : baseConf) {
            properties.put((String)entry.getKey(), (String)entry.getValue());
        }
        if (hiveCatalog.getHiveMetastoreUris() != null) {
            properties.put(HiveConf.ConfVars.METASTOREURIS.varname, hiveCatalog.getHiveMetastoreUris());
        }
        this.putConfigurationProperties(hiveCatalog.getConfigurationProperties(), properties);
        HiveConf hiveConf = new HiveConfFactory(siteXml, properties).newInstance();
        return hiveConf;
    }

    private void setCredentialProviderPath(Security security, Map<String, String> properties) {
        if (security.getCredentialProvider() != null) {
            properties.put("hadoop.security.credential.provider.path", security.getCredentialProvider());
        }
    }

    private void putConfigurationProperties(Map<String, String> configurationProperties, Map<String, String> properties) {
        if (configurationProperties != null) {
            properties.putAll(configurationProperties);
        }
    }

    @Profile(value={"replication"})
    @Bean
    ConditionalMetaStoreClientFactory thriftHiveMetaStoreClientFactory() {
        return new ThriftHiveMetaStoreClientFactory();
    }

    @Profile(value={"replication"})
    @Bean
    ConditionalMetaStoreClientFactoryManager conditionalMetaStoreClientFactoryManager(List<ConditionalMetaStoreClientFactory> factories) {
        return new ConditionalMetaStoreClientFactoryManager(factories);
    }

    @Profile(value={"replication"})
    @Bean
    Supplier<CloseableMetaStoreClient> sourceMetaStoreClientSupplier(SourceCatalog sourceCatalog, @Value(value="#{sourceHiveConf}") HiveConf sourceHiveConf, ConditionalMetaStoreClientFactoryManager conditionalMetaStoreClientFactoryManager) {
        String metaStoreUris = sourceCatalog.getHiveMetastoreUris();
        if (metaStoreUris == null) {
            metaStoreUris = "thrift:";
        }
        MetaStoreClientFactory sourceMetaStoreClientFactory = conditionalMetaStoreClientFactoryManager.factoryForUri(metaStoreUris);
        return this.metaStoreClientSupplier(sourceHiveConf, sourceCatalog.getName(), sourceCatalog.getMetastoreTunnel(), sourceMetaStoreClientFactory);
    }

    @Profile(value={"replication"})
    @Bean
    Supplier<CloseableMetaStoreClient> replicaMetaStoreClientSupplier(ReplicaCatalog replicaCatalog, @Value(value="#{replicaHiveConf}") HiveConf replicaHiveConf, ConditionalMetaStoreClientFactoryManager conditionalMetaStoreClientFactoryManager) {
        String metaStoreUris = replicaCatalog.getHiveMetastoreUris();
        if (metaStoreUris == null) {
            metaStoreUris = "thrift:";
        }
        MetaStoreClientFactory replicaMetaStoreClientFactory = conditionalMetaStoreClientFactoryManager.factoryForUri(metaStoreUris);
        return this.metaStoreClientSupplier(replicaHiveConf, replicaCatalog.getName(), replicaCatalog.getMetastoreTunnel(), replicaMetaStoreClientFactory);
    }

    private Supplier<CloseableMetaStoreClient> metaStoreClientSupplier(HiveConf hiveConf, String name, MetastoreTunnel metastoreTunnel, MetaStoreClientFactory metaStoreClientFactory) {
        if (metastoreTunnel != null) {
            return new TunnellingMetaStoreClientSupplierBuilder().withName(name).withRoute(metastoreTunnel.getRoute()).withKnownHosts(metastoreTunnel.getKnownHosts()).withLocalHost(metastoreTunnel.getLocalhost()).withPort(metastoreTunnel.getPort()).withPrivateKeys(metastoreTunnel.getPrivateKeys()).withTimeout(metastoreTunnel.getTimeout()).withStrictHostKeyChecking(metastoreTunnel.getStrictHostKeyChecking()).build(hiveConf, metaStoreClientFactory);
        }
        return new HiveMetaStoreClientSupplier(metaStoreClientFactory, hiveConf, name);
    }
}

