/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core;

import com.google.common.collect.ImmutableList;
import com.hotels.bdp.circustrain.api.copier.CopierFactory;
import com.hotels.bdp.circustrain.api.copier.CopierFactoryManager;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Profile(value={"replication"})
@Component
@Order(value=0x7FFFFFFF)
public class DefaultCopierFactoryManager
implements CopierFactoryManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCopierFactoryManager.class);
    private static final String COPIER_FACTORY_CLASS = "copier-factory-class";
    private final List<CopierFactory> copierFactories;

    @Autowired
    public DefaultCopierFactoryManager(List<CopierFactory> copierFactories) {
        this.copierFactories = ImmutableList.copyOf(copierFactories);
    }

    @PostConstruct
    void postConstruct() {
        LOG.debug("Initialized with {} CopierFactories", (Object)this.copierFactories.size());
        for (CopierFactory copierFactory : this.copierFactories) {
            LOG.debug("CopierFactory class {}", (Object)copierFactory.getClass().getName());
        }
    }

    public CopierFactory getCopierFactory(Path sourceLocation, Path replicaLocation, Map<String, Object> copierOptions) {
        String sourceScheme = sourceLocation.toUri().getScheme();
        String replicaScheme = replicaLocation.toUri().getScheme();
        if (copierOptions.containsKey(COPIER_FACTORY_CLASS)) {
            for (CopierFactory copierFactory : this.copierFactories) {
                String copierFactoryClassName = copierFactory.getClass().getName();
                if (!copierFactoryClassName.equals(copierOptions.get(COPIER_FACTORY_CLASS).toString())) continue;
                LOG.debug("Found CopierFactory '{}' using config", (Object)copierFactoryClassName);
                return copierFactory;
            }
        } else {
            for (CopierFactory copierFactory : this.copierFactories) {
                String copierFactoryClassName = copierFactory.getClass().getName();
                if (!copierFactory.supportsSchemes(sourceScheme, replicaScheme)) continue;
                LOG.debug("Found CopierFactory '{}' for sourceScheme '{}' and replicaScheme '{}'", new Object[]{copierFactoryClassName, sourceScheme, replicaScheme});
                return copierFactory;
            }
        }
        throw new UnsupportedOperationException("No CopierFactory that suppports sourceScheme '" + sourceScheme + "' and replicaScheme '" + replicaScheme + "'");
    }
}

