/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core;

import com.hotels.bdp.circustrain.api.CircusTrainException;
import com.hotels.bdp.circustrain.api.Replication;
import com.hotels.bdp.circustrain.api.conf.TableReplication;
import com.hotels.bdp.circustrain.core.ReplicationFactoryImpl;
import com.hotels.bdp.circustrain.core.replica.DestructiveReplica;
import com.hotels.bdp.circustrain.core.source.DestructiveSource;
import org.apache.thrift.TException;

public class DestructiveReplication
implements Replication {
    private final ReplicationFactoryImpl upsertReplicationFactory;
    private final TableReplication tableReplication;
    private final DestructiveSource destructiveSource;
    private final DestructiveReplica destructiveReplica;
    private final String eventId;

    public DestructiveReplication(ReplicationFactoryImpl upsertReplicationFactory, TableReplication tableReplication, String eventId, DestructiveSource destructiveSource, DestructiveReplica destructiveReplica) {
        this.upsertReplicationFactory = upsertReplicationFactory;
        this.tableReplication = tableReplication;
        this.eventId = eventId;
        this.destructiveSource = destructiveSource;
        this.destructiveReplica = destructiveReplica;
    }

    public void replicate() throws CircusTrainException {
        try {
            if (!this.destructiveReplica.tableIsUnderCircusTrainControl()) {
                throw new CircusTrainException("Replica table '" + this.tableReplication.getQualifiedReplicaName() + "' is not controlled by circus train aborting replication, check configuration for correct replica name");
            }
            if (this.destructiveSource.tableExists()) {
                this.destructiveReplica.dropDeletedPartitions(this.destructiveSource.getPartitionNames());
                Replication replication = this.upsertReplicationFactory.newInstance(this.tableReplication);
                replication.replicate();
            } else {
                this.destructiveReplica.dropTable();
            }
        }
        catch (TException e) {
            throw new CircusTrainException((Throwable)e);
        }
    }

    public String name() {
        return "destructive-" + this.tableReplication.getQualifiedReplicaName();
    }

    public String getEventId() {
        return this.eventId;
    }
}

