/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.hotels.bdp.circustrain.api.CircusTrainException;
import com.hotels.bdp.circustrain.api.conf.TableReplication;
import com.hotels.bdp.circustrain.comparator.ComparatorRegistry;
import com.hotels.bdp.circustrain.comparator.api.ComparatorType;
import com.hotels.bdp.circustrain.core.HiveEndpoint;
import com.hotels.bdp.circustrain.core.PartitionPredicate;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Table;

public class DiffGeneratedPartitionPredicate
implements PartitionPredicate {
    private final TableReplication tableReplication;
    private final HiveEndpoint source;
    private final HiveEndpoint replica;
    private final Function<Path, String> checksumFunction;
    private String partitionPredicate;
    private boolean generated = false;
    private Short partitionLimit = -1;

    public DiffGeneratedPartitionPredicate(@Nonnull HiveEndpoint source, @Nonnull HiveEndpoint replica, TableReplication tableReplication, Function<Path, String> checksumFunction) {
        this.source = source;
        this.replica = replica;
        this.tableReplication = tableReplication;
        this.checksumFunction = checksumFunction;
        if (tableReplication.getSourceTable().getPartitionLimit() != null) {
            this.partitionLimit = tableReplication.getSourceTable().getPartitionLimit();
        }
    }

    /*
     * Exception decompiling
     */
    private String generate() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Optional<Table> getReplicaTable(TableReplication tableReplication) {
        try {
            return Optional.of((Object)this.replica.getTableAndStatistics(tableReplication).getTable());
        }
        catch (CircusTrainException e) {
            return Optional.absent();
        }
    }

    private ComparatorRegistry comparatorRegistry() {
        return new ComparatorRegistry(ComparatorType.SHORT_CIRCUIT);
    }

    @Override
    public String getPartitionPredicate() {
        if (!this.generated) {
            this.partitionPredicate = this.generate();
            this.generated = true;
        }
        return this.partitionPredicate;
    }

    @Override
    public short getPartitionPredicateLimit() {
        if (Strings.isNullOrEmpty((String)this.getPartitionPredicate())) {
            return 0;
        }
        return this.partitionLimit;
    }
}

