/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.hotels.bdp.circustrain.api.CircusTrainException;
import com.hotels.bdp.circustrain.api.conf.TableReplication;
import com.hotels.bdp.circustrain.core.PartitionsAndStatistics;
import com.hotels.bdp.circustrain.core.TableAndStatistics;
import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;
import com.hotels.hcommon.hive.metastore.exception.MetaStoreClientException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class HiveEndpoint {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String name;
    private final HiveConf hiveConf;
    private final Supplier<CloseableMetaStoreClient> metaStoreClientSupplier;

    @Autowired
    public HiveEndpoint(String name, HiveConf hiveConf, Supplier<CloseableMetaStoreClient> metaStoreClientSupplier) {
        this.name = name;
        this.hiveConf = hiveConf;
        this.metaStoreClientSupplier = metaStoreClientSupplier;
    }

    public String getName() {
        return this.name;
    }

    public HiveConf getHiveConf() {
        return this.hiveConf;
    }

    public String getMetaStoreUris() {
        return this.hiveConf.getVar(HiveConf.ConfVars.METASTOREURIS);
    }

    public Supplier<CloseableMetaStoreClient> getMetaStoreClientSupplier() {
        return this.metaStoreClientSupplier;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Database getDatabase(String database) {
        this.log.debug("Retrieving database metadata for '{}'", (Object)database);
        try (CloseableMetaStoreClient client = (CloseableMetaStoreClient)this.metaStoreClientSupplier.get();){
            Database database2 = client.getDatabase(database);
            return database2;
        }
        catch (NoSuchObjectException e) {
            String message = String.format("Database '%s' not found", database);
            throw new CircusTrainException(message, (Throwable)e);
        }
        catch (Exception e) {
            String message = String.format("Cannot fetch database metadata for '%s'", database);
            throw new MetaStoreClientException(message, (Throwable)e);
        }
    }

    public Optional<Table> getTable(CloseableMetaStoreClient client, String database, String table) {
        Table oldReplicaTable = null;
        try {
            this.log.debug("Checking for existing table {}.{}", (Object)database, (Object)table);
            oldReplicaTable = client.getTable(database, table);
            this.log.debug("Existing table found.");
        }
        catch (NoSuchObjectException e) {
            this.log.debug("Table '{}.{}' not found.", (Object)database, (Object)table);
        }
        catch (TException e) {
            String message = String.format("Cannot fetch table metadata for '%s.%s'", database, table);
            this.log.error(message, (Throwable)e);
            throw new MetaStoreClientException(message, (Throwable)e);
        }
        return Optional.fromNullable((Object)oldReplicaTable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TableAndStatistics getTableAndStatistics(String database, String tableName) {
        this.log.info("Retrieving table metadata for '{}.{}'", (Object)database, (Object)tableName);
        try (CloseableMetaStoreClient client = (CloseableMetaStoreClient)this.metaStoreClientSupplier.get();){
            Table table = client.getTable(database, tableName);
            List<String> columnNames = this.getColumnNames(table);
            List statisticsObj = client.getTableColumnStatistics(database, tableName, columnNames);
            ColumnStatistics statistics = null;
            if (statisticsObj != null && !statisticsObj.isEmpty()) {
                statistics = new ColumnStatistics(new ColumnStatisticsDesc(true, table.getDbName(), table.getTableName()), statisticsObj);
                this.log.debug("Retrieved {} column stats entries for table {}.{}", new Object[]{statisticsObj.size(), table.getDbName(), table.getTableName()});
            } else {
                this.log.debug("No table column stats retrieved for table {}.{}", (Object)table.getDbName(), (Object)table.getTableName());
            }
            TableAndStatistics tableAndStatistics = new TableAndStatistics(table, statistics);
            return tableAndStatistics;
        }
        catch (NoSuchObjectException e) {
            String message = String.format("Table '%s.%s' not found", database, tableName);
            throw new CircusTrainException(message, (Throwable)e);
        }
        catch (TException e) {
            String message = String.format("Cannot fetch table metadata for '%s.%s'", database, tableName);
            throw new MetaStoreClientException(message, (Throwable)e);
        }
    }

    public abstract TableAndStatistics getTableAndStatistics(TableReplication var1);

    private List<String> getColumnNames(Table table) {
        List fields = table.getSd().getCols();
        ArrayList<String> columnNames = new ArrayList<String>(fields.size());
        for (FieldSchema field : fields) {
            columnNames.add(field.getName());
        }
        return columnNames;
    }

    public PartitionsAndStatistics getPartitions(Table table, String partitionPredicate, int maxPartitions) throws TException {
        try (CloseableMetaStoreClient client = (CloseableMetaStoreClient)this.metaStoreClientSupplier.get();){
            List partitions = null;
            partitions = Strings.isNullOrEmpty((String)partitionPredicate) ? client.listPartitions(table.getDbName(), table.getTableName(), (short)maxPartitions) : client.listPartitionsByFilter(table.getDbName(), table.getTableName(), partitionPredicate, (short)maxPartitions);
            List<String> partitionNames = this.getPartitionNames(table.getPartitionKeys(), partitions);
            List<String> columnNames = this.getColumnNames(table);
            Map statisticsByPartitionName = client.getPartitionColumnStatistics(table.getDbName(), table.getTableName(), partitionNames, columnNames);
            if (statisticsByPartitionName != null && !statisticsByPartitionName.isEmpty()) {
                this.log.debug("Retrieved column stats entries for {} partitions of table {}.{}", new Object[]{statisticsByPartitionName.size(), table.getDbName(), table.getTableName()});
            } else {
                this.log.debug("No partition column stats retrieved for table {}.{}", (Object)table.getDbName(), (Object)table.getTableName());
            }
            PartitionsAndStatistics partitionsAndStatistics = new PartitionsAndStatistics(table.getPartitionKeys(), partitions, statisticsByPartitionName);
            return partitionsAndStatistics;
        }
    }

    private List<String> getPartitionNames(List<FieldSchema> partitionKeys, List<Partition> partitions) throws MetaException {
        ArrayList<String> partitionNames = new ArrayList<String>(partitions.size());
        for (Partition partition : partitions) {
            partitionNames.add(Warehouse.makePartName(partitionKeys, (List)partition.getValues()));
        }
        return partitionNames;
    }
}

