/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.hotels.bdp.circustrain.api.CompletionCode;
import com.hotels.bdp.circustrain.api.Replication;
import com.hotels.bdp.circustrain.api.conf.ReplicaCatalog;
import com.hotels.bdp.circustrain.api.conf.Security;
import com.hotels.bdp.circustrain.api.conf.SourceCatalog;
import com.hotels.bdp.circustrain.api.conf.TableReplication;
import com.hotels.bdp.circustrain.api.conf.TableReplications;
import com.hotels.bdp.circustrain.api.event.LocomotiveListener;
import com.hotels.bdp.circustrain.api.event.TableReplicationListener;
import com.hotels.bdp.circustrain.api.metrics.MetricSender;
import com.hotels.bdp.circustrain.core.ReplicationFactory;
import com.hotels.bdp.circustrain.core.event.EventUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Profile(value={"replication"})
@Component
@Order(value=-2147483648)
class Locomotive
implements ApplicationRunner,
ExitCodeGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(Locomotive.class);
    private final List<TableReplication> tableReplications;
    private final ReplicationFactory replicationFactory;
    private final MetricSender metricSender;
    private final SourceCatalog sourceCatalog;
    private final ReplicaCatalog replicaCatalog;
    private final Security security;
    private final LocomotiveListener locomotiveListener;
    private final TableReplicationListener tableReplicationListener;
    private long replicationFailures;

    @Autowired
    Locomotive(SourceCatalog sourceCatalog, ReplicaCatalog replicaCatalog, Security security, TableReplications tableReplications, ReplicationFactory replicationFactory, MetricSender metricSender, LocomotiveListener locomotiveListener, TableReplicationListener tableReplicationListener) {
        this.sourceCatalog = sourceCatalog;
        this.replicaCatalog = replicaCatalog;
        this.security = security;
        this.locomotiveListener = locomotiveListener;
        this.tableReplicationListener = tableReplicationListener;
        this.tableReplications = tableReplications.getTableReplications();
        this.replicationFactory = replicationFactory;
        this.metricSender = metricSender;
    }

    public void run(ApplicationArguments args) {
        this.locomotiveListener.circusTrainStartUp(args.getSourceArgs(), EventUtils.toEventSourceCatalog(this.sourceCatalog), EventUtils.toEventReplicaCatalog(this.replicaCatalog, this.security));
        CompletionCode completionCode = CompletionCode.SUCCESS;
        ImmutableMap.Builder metrics = ImmutableMap.builder();
        this.replicationFailures = 0L;
        long replicated = 0L;
        LOG.info("{} tables to replicate.", (Object)this.tableReplications.size());
        for (TableReplication tableReplication : this.tableReplications) {
            String summary = this.getReplicationSummary(tableReplication);
            LOG.info("Replicating {} replication mode '{}', strategy '{}'.", new Object[]{summary, tableReplication.getReplicationMode(), tableReplication.getReplicationStrategy()});
            try {
                Replication replication = this.replicationFactory.newInstance(tableReplication);
                this.tableReplicationListener.tableReplicationStart(EventUtils.toEventTableReplication(tableReplication), replication.getEventId());
                replication.replicate();
                LOG.info("Completed replicating: {}.", (Object)summary);
                this.tableReplicationListener.tableReplicationSuccess(EventUtils.toEventTableReplication(tableReplication), replication.getEventId());
            }
            catch (Throwable t) {
                ++this.replicationFailures;
                completionCode = CompletionCode.FAILURE;
                LOG.error("Failed to replicate: {}.", (Object)summary, (Object)t);
                this.tableReplicationListener.tableReplicationFailure(EventUtils.toEventTableReplication(tableReplication), "event-id-unavailable", t);
            }
            ++replicated;
        }
        metrics.put((Object)"tables_replicated", (Object)replicated);
        metrics.put((Object)completionCode.getMetricName(), (Object)completionCode.getCode());
        ImmutableMap metricsMap = metrics.build();
        this.metricSender.send((Map)metricsMap);
        this.locomotiveListener.circusTrainShutDown(completionCode, (Map)metricsMap);
    }

    public int getExitCode() {
        if (this.replicationFailures == (long)this.tableReplications.size()) {
            return -1;
        }
        if (this.replicationFailures > 0L) {
            return -2;
        }
        return 0;
    }

    @VisibleForTesting
    String getReplicationSummary(TableReplication tableReplication) {
        return String.format("%s:%s to %s:%s", this.sourceCatalog.getName(), tableReplication.getSourceTable().getQualifiedName(), this.replicaCatalog.getName(), tableReplication.getQualifiedReplicaName());
    }
}

