/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core;

import com.google.common.base.Function;
import com.hotels.bdp.circustrain.api.conf.TableReplication;
import com.hotels.bdp.circustrain.core.DiffGeneratedPartitionPredicate;
import com.hotels.bdp.circustrain.core.HiveEndpoint;
import com.hotels.bdp.circustrain.core.HiveEndpointFactory;
import com.hotels.bdp.circustrain.core.PartitionPredicate;
import com.hotels.bdp.circustrain.core.SpelParsedPartitionPredicate;
import com.hotels.bdp.circustrain.core.conf.SpringExpressionParser;
import org.apache.hadoop.fs.Path;

public class PartitionPredicateFactory {
    private final SpringExpressionParser expressionParser;
    private final HiveEndpointFactory<? extends HiveEndpoint> sourceFactory;
    private final HiveEndpointFactory<? extends HiveEndpoint> replicaFactory;
    private final Function<Path, String> checksumFunction;

    public PartitionPredicateFactory(HiveEndpointFactory<? extends HiveEndpoint> sourceFactory, HiveEndpointFactory<? extends HiveEndpoint> replicaFactory, SpringExpressionParser expressionParser, Function<Path, String> checksumFunction) {
        this.sourceFactory = sourceFactory;
        this.replicaFactory = replicaFactory;
        this.expressionParser = expressionParser;
        this.checksumFunction = checksumFunction;
    }

    public PartitionPredicate newInstance(TableReplication tableReplication) {
        if (tableReplication.getSourceTable().isGeneratePartitionFilter()) {
            return new DiffGeneratedPartitionPredicate(this.sourceFactory.newInstance(tableReplication), this.replicaFactory.newInstance(tableReplication), tableReplication, this.checksumFunction);
        }
        return new SpelParsedPartitionPredicate(this.expressionParser, tableReplication);
    }
}

