/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core;

import com.hotels.bdp.circustrain.api.CircusTrainException;
import com.hotels.bdp.circustrain.api.Replication;
import com.hotels.bdp.circustrain.api.SourceLocationManager;
import com.hotels.bdp.circustrain.api.util.DotJoiner;
import com.hotels.bdp.circustrain.core.EventIdFactory;
import com.hotels.bdp.circustrain.core.EventIdPrefix;
import com.hotels.bdp.circustrain.core.PartitionPredicate;
import com.hotels.bdp.circustrain.core.PartitionedTableReplication;
import com.hotels.bdp.circustrain.core.PartitionsAndStatistics;
import com.hotels.bdp.circustrain.core.TableAndStatistics;
import com.hotels.bdp.circustrain.core.replica.MetadataMirrorReplicaLocationManager;
import com.hotels.bdp.circustrain.core.replica.Replica;
import com.hotels.bdp.circustrain.core.replica.TableType;
import com.hotels.bdp.circustrain.core.source.Source;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PartitionedTableMetadataMirrorReplication
implements Replication {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionedTableReplication.class);
    private final String database;
    private final String table;
    private final Source source;
    private final Replica replica;
    private final String eventId;
    private final PartitionPredicate partitionPredicate;
    private final String replicaDatabaseName;
    private final String replicaTableName;

    PartitionedTableMetadataMirrorReplication(String database, String table, PartitionPredicate partitionPredicate, Source source, Replica replica, EventIdFactory eventIdFactory, String replicaDatabaseName, String replicaTableName) {
        this.database = database;
        this.table = table;
        this.partitionPredicate = partitionPredicate;
        this.source = source;
        this.replica = replica;
        this.replicaDatabaseName = replicaDatabaseName;
        this.replicaTableName = replicaTableName;
        this.eventId = eventIdFactory.newEventId(EventIdPrefix.CIRCUS_TRAIN_PARTITIONED_TABLE.getPrefix());
    }

    public void replicate() throws CircusTrainException {
        try {
            TableAndStatistics sourceTableAndStatistics = this.source.getTableAndStatistics(this.database, this.table);
            Table sourceTable = sourceTableAndStatistics.getTable();
            PartitionsAndStatistics sourcePartitionsAndStatistics = this.source.getPartitions(sourceTable, this.partitionPredicate.getPartitionPredicate(), this.partitionPredicate.getPartitionPredicateLimit());
            List<Partition> sourcePartitions = sourcePartitionsAndStatistics.getPartitions();
            this.replica.validateReplicaTable(this.replicaDatabaseName, this.replicaTableName);
            SourceLocationManager sourceLocationManager = this.source.getLocationManager(sourceTable, sourcePartitions, this.eventId, Collections.emptyMap());
            MetadataMirrorReplicaLocationManager replicaLocationManager = new MetadataMirrorReplicaLocationManager(sourceLocationManager, TableType.PARTITIONED);
            sourceLocationManager.cleanUpLocations();
            if (sourcePartitions.isEmpty()) {
                LOG.debug("Update table {}.{} metadata only", (Object)this.database, (Object)this.table);
                this.replica.updateMetadata(this.eventId, sourceTableAndStatistics, this.replicaDatabaseName, this.replicaTableName, replicaLocationManager);
                LOG.info("No matching partitions found on table {}.{} with predicate {}. Table metadata updated, no partitions were updated.", new Object[]{this.database, this.table, this.partitionPredicate});
            } else {
                this.replica.updateMetadata(this.eventId, sourceTableAndStatistics, sourcePartitionsAndStatistics, this.replicaDatabaseName, this.replicaTableName, replicaLocationManager);
                int partitionsCopied = sourcePartitions.size();
                LOG.info("Metadata mirrored for {} partitions of table {}.{} (no data copied).", new Object[]{partitionsCopied, this.database, this.table});
            }
        }
        catch (Throwable t) {
            throw new CircusTrainException("Unable to replicate", t);
        }
    }

    public String name() {
        return DotJoiner.join((String[])new String[]{this.database, this.table});
    }

    public String getEventId() {
        return this.eventId;
    }
}

