/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core;

import com.google.common.base.Optional;
import com.hotels.bdp.circustrain.api.CircusTrainException;
import com.hotels.bdp.circustrain.api.ReplicaLocationManager;
import com.hotels.bdp.circustrain.api.Replication;
import com.hotels.bdp.circustrain.api.conf.ReplicationMode;
import com.hotels.bdp.circustrain.api.util.DotJoiner;
import com.hotels.bdp.circustrain.core.EventIdFactory;
import com.hotels.bdp.circustrain.core.EventIdPrefix;
import com.hotels.bdp.circustrain.core.PartitionPredicate;
import com.hotels.bdp.circustrain.core.PartitionsAndStatistics;
import com.hotels.bdp.circustrain.core.TableAndStatistics;
import com.hotels.bdp.circustrain.core.replica.InvalidReplicationModeException;
import com.hotels.bdp.circustrain.core.replica.MetadataUpdateReplicaLocationManager;
import com.hotels.bdp.circustrain.core.replica.Replica;
import com.hotels.bdp.circustrain.core.replica.TableType;
import com.hotels.bdp.circustrain.core.source.Source;
import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionedTableMetadataUpdateReplication
implements Replication {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionedTableMetadataUpdateReplication.class);
    private final String eventId;
    private final String database;
    private final String table;
    private final PartitionPredicate partitionPredicate;
    private final Source source;
    private final Replica replica;
    private final String targetTableLocation;
    private final String replicaDatabaseName;
    private final String replicaTableName;

    public PartitionedTableMetadataUpdateReplication(String database, String table, PartitionPredicate partitionPredicate, Source source, Replica replica, EventIdFactory eventIdFactory, String targetTableLocation, String replicaDatabaseName, String replicaTableName) {
        this.database = database;
        this.table = table;
        this.partitionPredicate = partitionPredicate;
        this.source = source;
        this.replica = replica;
        this.targetTableLocation = targetTableLocation;
        this.replicaDatabaseName = replicaDatabaseName;
        this.replicaTableName = replicaTableName;
        this.eventId = eventIdFactory.newEventId(EventIdPrefix.CIRCUS_TRAIN_PARTITIONED_TABLE.getPrefix());
    }

    public void replicate() throws CircusTrainException {
        try {
            TableAndStatistics sourceTableAndStatistics = this.source.getTableAndStatistics(this.database, this.table);
            Table sourceTable = sourceTableAndStatistics.getTable();
            PartitionsAndStatistics sourcePartitionsAndStatistics = this.source.getPartitions(sourceTable, this.partitionPredicate.getPartitionPredicate(), this.partitionPredicate.getPartitionPredicateLimit());
            List<Partition> sourcePartitions = sourcePartitionsAndStatistics.getPartitions();
            this.replica.validateReplicaTable(this.replicaDatabaseName, this.replicaTableName);
            try (CloseableMetaStoreClient client = (CloseableMetaStoreClient)this.replica.getMetaStoreClientSupplier().get();){
                if (sourcePartitions.isEmpty()) {
                    ReplicaLocationManager replicaLocationManager = this.newMetadataUpdateReplicaLocationManager(client, this.targetTableLocation);
                    LOG.debug("Update table {}.{} metadata only", (Object)this.database, (Object)this.table);
                    this.replica.updateMetadata(this.eventId, sourceTableAndStatistics, this.replicaDatabaseName, this.replicaTableName, replicaLocationManager);
                    LOG.info("No matching partitions found on table {}.{} with predicate {}. Table metadata updated, no partitions were updated.", new Object[]{this.database, this.table, this.partitionPredicate});
                } else {
                    String previousLocation = this.getPreviousLocation(client);
                    ReplicaLocationManager replicaLocationManager = this.newMetadataUpdateReplicaLocationManager(client, previousLocation);
                    PartitionsAndStatistics sourcePartitionsAndStatisticsThatWereReplicated = this.filterOnReplicatedPartitions(client, sourcePartitionsAndStatistics, sourceTable.getPartitionKeys());
                    this.replica.updateMetadata(this.eventId, sourceTableAndStatistics, sourcePartitionsAndStatisticsThatWereReplicated, this.replicaDatabaseName, this.replicaTableName, replicaLocationManager);
                    int partitionsCopied = sourcePartitions.size();
                    LOG.info("Metadata updated for {} partitions of table {}.{}. (no data copied)", new Object[]{partitionsCopied, this.database, this.table});
                }
            }
        }
        catch (Throwable t) {
            throw new CircusTrainException("Unable to replicate", t);
        }
    }

    private ReplicaLocationManager newMetadataUpdateReplicaLocationManager(CloseableMetaStoreClient client, String previousLocation) {
        return new MetadataUpdateReplicaLocationManager(client, TableType.PARTITIONED, previousLocation, this.replicaDatabaseName, this.replicaTableName);
    }

    private PartitionsAndStatistics filterOnReplicatedPartitions(CloseableMetaStoreClient replicaClient, PartitionsAndStatistics sourcePartitionsAndStatistics, List<FieldSchema> partitionKeys) throws TException {
        LinkedHashMap<Partition, ColumnStatistics> statisticsByPartition = new LinkedHashMap<Partition, ColumnStatistics>();
        for (Partition partition : sourcePartitionsAndStatistics.getPartitions()) {
            try {
                replicaClient.getPartition(this.replicaDatabaseName, this.replicaTableName, partition.getValues());
                statisticsByPartition.put(partition, sourcePartitionsAndStatistics.getStatisticsForPartition(partition));
            }
            catch (NoSuchObjectException e) {
                LOG.debug("Partition {} doesn't exist, skipping it...", (Object)Warehouse.getQualifiedName((Partition)partition));
            }
        }
        return new PartitionsAndStatistics(partitionKeys, statisticsByPartition);
    }

    private String getPreviousLocation(CloseableMetaStoreClient replicaClient) {
        Optional<Table> previousTable = this.replica.getTable(replicaClient, this.replicaDatabaseName, this.replicaTableName);
        if (!previousTable.isPresent()) {
            throw new InvalidReplicationModeException("Trying a " + ReplicationMode.METADATA_UPDATE.name() + " on a table that wasn't replicated before. This is not possible, rerun with a different table name or change the replication mode to " + ReplicationMode.FULL.name() + ".");
        }
        return ((Table)previousTable.get()).getSd().getLocation();
    }

    public String name() {
        return DotJoiner.join((String[])new String[]{this.database, this.table});
    }

    public String getEventId() {
        return this.eventId;
    }
}

