/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core;

import com.hotels.bdp.circustrain.api.CircusTrainException;
import com.hotels.bdp.circustrain.api.ReplicaLocationManager;
import com.hotels.bdp.circustrain.api.Replication;
import com.hotels.bdp.circustrain.api.SourceLocationManager;
import com.hotels.bdp.circustrain.api.conf.TableReplication;
import com.hotels.bdp.circustrain.api.copier.Copier;
import com.hotels.bdp.circustrain.api.copier.CopierContext;
import com.hotels.bdp.circustrain.api.copier.CopierFactory;
import com.hotels.bdp.circustrain.api.copier.CopierFactoryManager;
import com.hotels.bdp.circustrain.api.data.DataManipulator;
import com.hotels.bdp.circustrain.api.data.DataManipulatorFactory;
import com.hotels.bdp.circustrain.api.data.DataManipulatorFactoryManager;
import com.hotels.bdp.circustrain.api.event.CopierListener;
import com.hotels.bdp.circustrain.api.metrics.Metrics;
import com.hotels.bdp.circustrain.api.util.DotJoiner;
import com.hotels.bdp.circustrain.core.EventIdFactory;
import com.hotels.bdp.circustrain.core.EventIdPrefix;
import com.hotels.bdp.circustrain.core.PartitionPredicate;
import com.hotels.bdp.circustrain.core.PartitionsAndStatistics;
import com.hotels.bdp.circustrain.core.TableAndStatistics;
import com.hotels.bdp.circustrain.core.replica.Replica;
import com.hotels.bdp.circustrain.core.replica.TableType;
import com.hotels.bdp.circustrain.core.source.Source;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PartitionedTableReplication
implements Replication {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionedTableReplication.class);
    private final String database;
    private final String table;
    private final Source source;
    private final Replica replica;
    private final String eventId;
    private final CopierFactoryManager copierFactoryManager;
    private final PartitionPredicate partitionPredicate;
    private Metrics metrics = Metrics.NULL_VALUE;
    private final Map<String, Object> copierOptions;
    private final CopierListener copierListener;
    private final DataManipulatorFactoryManager dataManipulatorFactoryManager;
    private TableReplication tableReplication;

    PartitionedTableReplication(TableReplication tableReplication, PartitionPredicate partitionPredicate, Source source, Replica replica, CopierFactoryManager copierFactoryManager, EventIdFactory eventIdFactory, Map<String, Object> copierOptions, CopierListener copierListener, DataManipulatorFactoryManager dataManipulatorFactoryManager) {
        this.tableReplication = tableReplication;
        this.database = tableReplication.getSourceTable().getDatabaseName();
        this.table = tableReplication.getSourceTable().getTableName();
        this.partitionPredicate = partitionPredicate;
        this.source = source;
        this.replica = replica;
        this.copierFactoryManager = copierFactoryManager;
        this.copierOptions = copierOptions;
        this.copierListener = copierListener;
        this.dataManipulatorFactoryManager = dataManipulatorFactoryManager;
        this.eventId = eventIdFactory.newEventId(EventIdPrefix.CIRCUS_TRAIN_PARTITIONED_TABLE.getPrefix());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicate() throws CircusTrainException {
        block6: {
            try {
                String replicaDatabaseName = this.tableReplication.getReplicaDatabaseName();
                String replicaTableName = this.tableReplication.getReplicaTableName();
                TableAndStatistics sourceTableAndStatistics = this.source.getTableAndStatistics(this.database, this.table);
                Table sourceTable = sourceTableAndStatistics.getTable();
                PartitionsAndStatistics sourcePartitionsAndStatistics = this.source.getPartitions(sourceTable, this.partitionPredicate.getPartitionPredicate(), this.partitionPredicate.getPartitionPredicateLimit());
                List<Partition> sourcePartitions = sourcePartitionsAndStatistics.getPartitions();
                this.replica.validateReplicaTable(replicaDatabaseName, replicaTableName);
                SourceLocationManager sourceLocationManager = this.source.getLocationManager(sourceTable, sourcePartitions, this.eventId, this.copierOptions);
                Path sourceBaseLocation = sourceLocationManager.getTableLocation();
                List sourceSubLocations = sourceLocationManager.getPartitionLocations();
                ReplicaLocationManager replicaLocationManager = this.replica.getLocationManager(TableType.PARTITIONED, this.tableReplication.getReplicaTable().getTableLocation(), this.eventId, sourceLocationManager);
                Path replicaPartitionBaseLocation = replicaLocationManager.getPartitionBaseLocation();
                DataManipulatorFactory dataManipulatorFactory = this.dataManipulatorFactoryManager.getFactory(sourceBaseLocation, replicaPartitionBaseLocation, this.copierOptions);
                DataManipulator dataManipulator = dataManipulatorFactory.newInstance(replicaPartitionBaseLocation, this.copierOptions);
                if (sourcePartitions.isEmpty()) {
                    LOG.debug("Update table {}.{} metadata only", (Object)this.database, (Object)this.table);
                    this.replica.cleanupReplicaTableIfRequired(replicaDatabaseName, replicaTableName, dataManipulator);
                    this.replica.updateMetadata(this.eventId, sourceTableAndStatistics, replicaDatabaseName, replicaTableName, replicaLocationManager);
                    LOG.info("No matching partitions found on table {}.{} with predicate {}. Table metadata updated, no partitions were updated.", new Object[]{this.database, this.table, this.partitionPredicate});
                    break block6;
                }
                CopierFactory copierFactory = this.copierFactoryManager.getCopierFactory(sourceBaseLocation, replicaPartitionBaseLocation, this.copierOptions);
                CopierContext copierContext = new CopierContext(this.tableReplication, this.eventId, sourceBaseLocation, sourceSubLocations, replicaPartitionBaseLocation, this.copierOptions, sourceTable, sourcePartitions);
                Copier copier = copierFactory.newInstance(copierContext);
                this.copierListener.copierStart(copier.getClass().getName());
                try {
                    this.metrics = copier.copy();
                }
                finally {
                    this.copierListener.copierEnd(this.metrics);
                }
                sourceLocationManager.cleanUpLocations();
                this.replica.cleanupReplicaTableIfRequired(replicaDatabaseName, replicaTableName, dataManipulator);
                this.replica.updateMetadata(this.eventId, sourceTableAndStatistics, sourcePartitionsAndStatistics, replicaDatabaseName, replicaTableName, replicaLocationManager);
                replicaLocationManager.cleanUpLocations();
                int partitionsCopied = sourcePartitions.size();
                LOG.info("Replicated {} partitions of table {}.{}.", new Object[]{partitionsCopied, this.database, this.table});
            }
            catch (Throwable t) {
                throw new CircusTrainException("Unable to replicate", t);
            }
        }
    }

    public String name() {
        return DotJoiner.join((String[])new String[]{this.database, this.table});
    }

    public String getEventId() {
        return this.eventId;
    }
}

