/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionsAndStatistics {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionsAndStatistics.class);
    private final Map<Partition, ColumnStatistics> statisticsByPartition;
    private final List<String> partitionNames = new ArrayList<String>();
    private List<FieldSchema> partitionKeys;

    public PartitionsAndStatistics(List<FieldSchema> partitionKeys, List<Partition> partitions, Map<String, List<ColumnStatisticsObj>> statisticsByPartitionName) {
        this(partitionKeys, PartitionsAndStatistics.createStatisticsByPartitionMap(partitionKeys, partitions, statisticsByPartitionName));
    }

    public PartitionsAndStatistics(List<FieldSchema> partitionKeys, Map<Partition, ColumnStatistics> statisticsByPartition) {
        this.partitionKeys = partitionKeys;
        this.statisticsByPartition = statisticsByPartition;
        for (Partition partition : statisticsByPartition.keySet()) {
            String partitionName = PartitionsAndStatistics.getPartitionName(partitionKeys, partition);
            this.partitionNames.add(partitionName);
        }
    }

    private static Map<Partition, ColumnStatistics> createStatisticsByPartitionMap(List<FieldSchema> partitionKeys, List<Partition> partitions, Map<String, List<ColumnStatisticsObj>> statisticsByPartitionName) {
        int entryCount = 0;
        LinkedHashMap<Partition, ColumnStatistics> result = new LinkedHashMap<Partition, ColumnStatistics>(partitions.size());
        for (Partition partition : partitions) {
            if (partition == null) {
                throw new IllegalArgumentException("partition == null");
            }
            String partitionName = PartitionsAndStatistics.getPartitionName(partitionKeys, partition);
            ColumnStatistics statistics = null;
            List<ColumnStatisticsObj> statisticsObj = statisticsByPartitionName.get(partitionName);
            if (statisticsObj != null && !statisticsObj.isEmpty()) {
                entryCount += statisticsObj.size();
                ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc(false, partition.getDbName(), partition.getTableName());
                statsDesc.setPartName(partitionName);
                statistics = new ColumnStatistics(statsDesc, statisticsObj);
            }
            result.put(partition, statistics);
        }
        LOG.debug("Indexed {} column stats entries for {} partitions.", (Object)entryCount, (Object)statisticsByPartitionName.size());
        return result;
    }

    private static String getPartitionName(List<FieldSchema> partitionKeys, Partition partition) {
        try {
            return Warehouse.makePartName(partitionKeys, (List)partition.getValues());
        }
        catch (MetaException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Partition> getPartitions() {
        return Collections.unmodifiableList(new ArrayList<Partition>(this.statisticsByPartition.keySet()));
    }

    public List<FieldSchema> getPartitionKeys() {
        return Collections.unmodifiableList(this.partitionKeys);
    }

    public ColumnStatistics getStatisticsForPartition(Partition partition) {
        if (partition == null) {
            throw new IllegalArgumentException("partition == null");
        }
        return this.statisticsByPartition.get(partition);
    }

    public List<String> getPartitionNames() {
        return Collections.unmodifiableList(this.partitionNames);
    }
}

