/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core;

import com.hotels.bdp.circustrain.api.CircusTrainException;
import com.hotels.bdp.circustrain.api.Replication;
import com.hotels.bdp.circustrain.api.conf.ReplicationMode;
import com.hotels.bdp.circustrain.api.conf.SourceTable;
import com.hotels.bdp.circustrain.api.conf.TableReplication;
import com.hotels.bdp.circustrain.api.copier.CopierFactoryManager;
import com.hotels.bdp.circustrain.api.copier.CopierOptions;
import com.hotels.bdp.circustrain.api.data.DataManipulatorFactoryManager;
import com.hotels.bdp.circustrain.api.event.CopierListener;
import com.hotels.bdp.circustrain.core.EventIdFactory;
import com.hotels.bdp.circustrain.core.PartitionPredicate;
import com.hotels.bdp.circustrain.core.PartitionPredicateFactory;
import com.hotels.bdp.circustrain.core.PartitionedTableMetadataMirrorReplication;
import com.hotels.bdp.circustrain.core.PartitionedTableMetadataUpdateReplication;
import com.hotels.bdp.circustrain.core.PartitionedTableReplication;
import com.hotels.bdp.circustrain.core.ReplicationFactory;
import com.hotels.bdp.circustrain.core.TableAndStatistics;
import com.hotels.bdp.circustrain.core.UnpartitionedTableMetadataMirrorReplication;
import com.hotels.bdp.circustrain.core.UnpartitionedTableMetadataUpdateReplication;
import com.hotels.bdp.circustrain.core.UnpartitionedTableReplication;
import com.hotels.bdp.circustrain.core.replica.Replica;
import com.hotels.bdp.circustrain.core.replica.ReplicaFactory;
import com.hotels.bdp.circustrain.core.source.Source;
import com.hotels.bdp.circustrain.core.source.SourceFactory;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.Table;

public class ReplicationFactoryImpl
implements ReplicationFactory {
    private final EventIdFactory eventIdFactory = EventIdFactory.DEFAULT;
    private final SourceFactory sourceFactory;
    private final ReplicaFactory replicaFactory;
    private final CopierFactoryManager copierFactoryManager;
    private final CopierListener copierListener;
    private final PartitionPredicateFactory partitionPredicateFactory;
    private final CopierOptions copierOptions;
    private final DataManipulatorFactoryManager dataManipulatorFactoryManager;

    public ReplicationFactoryImpl(SourceFactory sourceFactory, ReplicaFactory replicaFactory, CopierFactoryManager copierFactoryManager, CopierListener copierListener, PartitionPredicateFactory partitionPredicateFactory, CopierOptions copierOptions, DataManipulatorFactoryManager dataManipulatorFactoryManager) {
        this.sourceFactory = sourceFactory;
        this.replicaFactory = replicaFactory;
        this.copierFactoryManager = copierFactoryManager;
        this.copierListener = copierListener;
        this.partitionPredicateFactory = partitionPredicateFactory;
        this.copierOptions = copierOptions;
        this.dataManipulatorFactoryManager = dataManipulatorFactoryManager;
    }

    @Override
    public Replication newInstance(TableReplication tableReplication) {
        Replica replica = this.replicaFactory.newInstance(tableReplication);
        SourceTable sourceTable = tableReplication.getSourceTable();
        String sourceDatabaseName = sourceTable.getDatabaseName();
        String sourceTableName = sourceTable.getTableName();
        Source source = this.sourceFactory.newInstance(tableReplication);
        this.validate(tableReplication, source, replica);
        TableAndStatistics tableAndStatistics = source.getTableAndStatistics(sourceDatabaseName, sourceTableName);
        List partitionKeys = tableAndStatistics.getTable().getPartitionKeys();
        Replication replication = null;
        replication = partitionKeys == null || partitionKeys.isEmpty() ? this.createUnpartitionedTableReplication(tableReplication, source, replica) : this.createPartitionedTableReplication(tableReplication, source, replica);
        return replication;
    }

    private Replication createPartitionedTableReplication(TableReplication tableReplication, Source source, Replica replica) {
        Object replication = null;
        PartitionPredicate partitionPredicate = this.partitionPredicateFactory.newInstance(tableReplication);
        switch (tableReplication.getReplicationMode()) {
            case METADATA_MIRROR: {
                replication = new PartitionedTableMetadataMirrorReplication(tableReplication.getSourceTable().getDatabaseName(), tableReplication.getSourceTable().getTableName(), partitionPredicate, source, replica, this.eventIdFactory, tableReplication.getReplicaDatabaseName(), tableReplication.getReplicaTableName());
                break;
            }
            case FULL_OVERWRITE: 
            case FULL: {
                Map mergedCopierOptions = tableReplication.getMergedCopierOptions(this.copierOptions.getCopierOptions());
                replication = new PartitionedTableReplication(tableReplication, partitionPredicate, source, replica, this.copierFactoryManager, this.eventIdFactory, mergedCopierOptions, this.copierListener, this.dataManipulatorFactoryManager);
                break;
            }
            case METADATA_UPDATE: {
                replication = new PartitionedTableMetadataUpdateReplication(tableReplication.getSourceTable().getDatabaseName(), tableReplication.getSourceTable().getTableName(), partitionPredicate, source, replica, this.eventIdFactory, tableReplication.getReplicaTable().getTableLocation(), tableReplication.getReplicaDatabaseName(), tableReplication.getReplicaTableName());
                break;
            }
            default: {
                throw new CircusTrainException(String.format("ReplicationMode %s is unsupported.", tableReplication.getReplicationMode()));
            }
        }
        return replication;
    }

    private Replication createUnpartitionedTableReplication(TableReplication tableReplication, Source source, Replica replica) {
        Object replication = null;
        switch (tableReplication.getReplicationMode()) {
            case METADATA_MIRROR: {
                replication = new UnpartitionedTableMetadataMirrorReplication(tableReplication.getSourceTable().getDatabaseName(), tableReplication.getSourceTable().getTableName(), source, replica, this.eventIdFactory, tableReplication.getReplicaDatabaseName(), tableReplication.getReplicaTableName());
                break;
            }
            case FULL_OVERWRITE: 
            case FULL: {
                Map mergedCopierOptions = tableReplication.getMergedCopierOptions(this.copierOptions.getCopierOptions());
                replication = new UnpartitionedTableReplication(tableReplication, source, replica, this.copierFactoryManager, this.eventIdFactory, mergedCopierOptions, this.copierListener, this.dataManipulatorFactoryManager);
                break;
            }
            case METADATA_UPDATE: {
                replication = new UnpartitionedTableMetadataUpdateReplication(tableReplication.getSourceTable().getDatabaseName(), tableReplication.getSourceTable().getTableName(), source, replica, this.eventIdFactory, tableReplication.getReplicaDatabaseName(), tableReplication.getReplicaTableName());
                break;
            }
            default: {
                throw new CircusTrainException(String.format("ReplicationMode %s is unsupported.", tableReplication.getReplicationMode()));
            }
        }
        return replication;
    }

    private void validate(TableReplication tableReplication, Source source, Replica replica) {
        source.getDatabase(tableReplication.getSourceTable().getDatabaseName());
        replica.getDatabase(tableReplication.getReplicaDatabaseName());
        TableAndStatistics sourceTableAndStatistics = source.getTableAndStatistics(tableReplication);
        if (tableReplication.getReplicationMode() != ReplicationMode.METADATA_MIRROR && MetaStoreUtils.isView((Table)sourceTableAndStatistics.getTable())) {
            throw new CircusTrainException(String.format("Cannot replicate view %s. Only %s is supported for views", tableReplication.getSourceTable().getQualifiedName(), ReplicationMode.METADATA_MIRROR.name()));
        }
    }
}

