/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core;

import com.hotels.bdp.circustrain.api.conf.TableReplication;
import com.hotels.bdp.circustrain.core.PartitionPredicate;
import com.hotels.bdp.circustrain.core.conf.SpringExpressionParser;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpelParsedPartitionPredicate
implements PartitionPredicate {
    private static final Logger LOG = LoggerFactory.getLogger(SpelParsedPartitionPredicate.class);
    private final TableReplication tableReplication;
    private final SpringExpressionParser expressionParser;

    public SpelParsedPartitionPredicate(SpringExpressionParser expressionParser, TableReplication tableReplication) {
        this.expressionParser = expressionParser;
        this.tableReplication = tableReplication;
    }

    @Override
    public String getPartitionPredicate() {
        String parsedPartitionFilter;
        String partitionFilter = this.tableReplication.getSourceTable().getPartitionFilter();
        if (!Objects.equals(partitionFilter, parsedPartitionFilter = this.expressionParser.parse(partitionFilter))) {
            LOG.info("Parsed partitionFilter: " + parsedPartitionFilter);
        }
        return parsedPartitionFilter;
    }

    @Override
    public short getPartitionPredicateLimit() {
        Short partitionLimit = this.tableReplication.getSourceTable().getPartitionLimit();
        return partitionLimit == null ? (short)-1 : (short)partitionLimit;
    }
}

