/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core;

import com.google.common.base.Supplier;
import com.hotels.bdp.circustrain.api.Replication;
import com.hotels.bdp.circustrain.api.conf.ReplicationStrategy;
import com.hotels.bdp.circustrain.api.conf.TableReplication;
import com.hotels.bdp.circustrain.api.event.ReplicaCatalogListener;
import com.hotels.bdp.circustrain.api.listener.HousekeepingListener;
import com.hotels.bdp.circustrain.core.DestructiveReplication;
import com.hotels.bdp.circustrain.core.EventIdFactory;
import com.hotels.bdp.circustrain.core.EventIdPrefix;
import com.hotels.bdp.circustrain.core.ReplicationFactory;
import com.hotels.bdp.circustrain.core.ReplicationFactoryImpl;
import com.hotels.bdp.circustrain.core.replica.CleanupLocationManager;
import com.hotels.bdp.circustrain.core.replica.CleanupLocationManagerFactory;
import com.hotels.bdp.circustrain.core.replica.DestructiveReplica;
import com.hotels.bdp.circustrain.core.source.DestructiveSource;
import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;

public class StrategyBasedReplicationFactory
implements ReplicationFactory {
    private final EventIdFactory eventIdFactory = EventIdFactory.DEFAULT;
    private final ReplicationFactoryImpl upsertReplicationFactory;
    private final Supplier<CloseableMetaStoreClient> sourceMetaStoreClientSupplier;
    private final Supplier<CloseableMetaStoreClient> replicaMetaStoreClientSupplier;
    private final HousekeepingListener housekeepingListener;
    private final ReplicaCatalogListener replicaCatalogListener;

    public StrategyBasedReplicationFactory(ReplicationFactoryImpl upsertReplicationFactory, Supplier<CloseableMetaStoreClient> sourceMetaStoreClientSupplier, Supplier<CloseableMetaStoreClient> replicaMetaStoreClientSupplier, HousekeepingListener housekeepingListener, ReplicaCatalogListener replicaCatalogListener) {
        this.upsertReplicationFactory = upsertReplicationFactory;
        this.sourceMetaStoreClientSupplier = sourceMetaStoreClientSupplier;
        this.replicaMetaStoreClientSupplier = replicaMetaStoreClientSupplier;
        this.housekeepingListener = housekeepingListener;
        this.replicaCatalogListener = replicaCatalogListener;
    }

    @Override
    public Replication newInstance(TableReplication tableReplication) {
        if (tableReplication.getReplicationStrategy() == ReplicationStrategy.PROPAGATE_DELETES) {
            String eventId = this.eventIdFactory.newEventId(EventIdPrefix.CIRCUS_TRAIN_DESTRUCTIVE.getPrefix());
            CleanupLocationManager cleanupLocationManager = CleanupLocationManagerFactory.newInstance(eventId, this.housekeepingListener, this.replicaCatalogListener, tableReplication);
            return new DestructiveReplication(this.upsertReplicationFactory, tableReplication, eventId, new DestructiveSource(this.sourceMetaStoreClientSupplier, tableReplication), new DestructiveReplica(this.replicaMetaStoreClientSupplier, cleanupLocationManager, tableReplication));
        }
        return this.upsertReplicationFactory.newInstance(tableReplication);
    }
}

