/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core;

import com.hotels.bdp.circustrain.api.CircusTrainException;
import com.hotels.bdp.circustrain.api.Replication;
import com.hotels.bdp.circustrain.api.SourceLocationManager;
import com.hotels.bdp.circustrain.api.util.DotJoiner;
import com.hotels.bdp.circustrain.core.EventIdFactory;
import com.hotels.bdp.circustrain.core.EventIdPrefix;
import com.hotels.bdp.circustrain.core.TableAndStatistics;
import com.hotels.bdp.circustrain.core.replica.MetadataMirrorReplicaLocationManager;
import com.hotels.bdp.circustrain.core.replica.Replica;
import com.hotels.bdp.circustrain.core.replica.TableType;
import com.hotels.bdp.circustrain.core.source.Source;
import org.apache.hadoop.hive.metastore.api.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnpartitionedTableMetadataMirrorReplication
implements Replication {
    private static final Logger LOG = LoggerFactory.getLogger(UnpartitionedTableMetadataMirrorReplication.class);
    protected final String database;
    protected final String table;
    protected final Source source;
    protected final Replica replica;
    protected final String eventId;
    private final String replicaDatabaseName;
    private final String replicaTableName;

    UnpartitionedTableMetadataMirrorReplication(String database, String table, Source source, Replica replica, EventIdFactory eventIdFactory, String replicaDatabaseName, String replicaTableName) {
        this.database = database;
        this.table = table;
        this.source = source;
        this.replica = replica;
        this.replicaDatabaseName = replicaDatabaseName;
        this.replicaTableName = replicaTableName;
        this.eventId = eventIdFactory.newEventId(EventIdPrefix.CIRCUS_TRAIN_UNPARTITIONED_TABLE.getPrefix());
    }

    public void replicate() throws CircusTrainException {
        try {
            this.replica.validateReplicaTable(this.replicaDatabaseName, this.replicaTableName);
            TableAndStatistics sourceTableAndStatistics = this.source.getTableAndStatistics(this.database, this.table);
            Table sourceTable = sourceTableAndStatistics.getTable();
            SourceLocationManager sourceLocationManager = this.source.getLocationManager(sourceTable, this.eventId);
            MetadataMirrorReplicaLocationManager replicaLocationManager = new MetadataMirrorReplicaLocationManager(sourceLocationManager, TableType.UNPARTITIONED);
            sourceLocationManager.cleanUpLocations();
            this.replica.updateMetadata(this.eventId, sourceTableAndStatistics, this.replicaDatabaseName, this.replicaTableName, replicaLocationManager);
            LOG.info("Metadata mirrored for table {}.{} (no data copied).", (Object)this.database, (Object)this.table);
        }
        catch (Throwable t) {
            throw new CircusTrainException("Unable to replicate", t);
        }
    }

    public String name() {
        return DotJoiner.join((String[])new String[]{this.database, this.table});
    }

    public String getEventId() {
        return this.eventId;
    }
}

