/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core;

import com.google.common.base.Optional;
import com.hotels.bdp.circustrain.api.CircusTrainException;
import com.hotels.bdp.circustrain.api.Replication;
import com.hotels.bdp.circustrain.api.conf.ReplicationMode;
import com.hotels.bdp.circustrain.api.util.DotJoiner;
import com.hotels.bdp.circustrain.core.EventIdFactory;
import com.hotels.bdp.circustrain.core.EventIdPrefix;
import com.hotels.bdp.circustrain.core.TableAndStatistics;
import com.hotels.bdp.circustrain.core.UnpartitionedTableReplication;
import com.hotels.bdp.circustrain.core.replica.InvalidReplicationModeException;
import com.hotels.bdp.circustrain.core.replica.MetadataUpdateReplicaLocationManager;
import com.hotels.bdp.circustrain.core.replica.Replica;
import com.hotels.bdp.circustrain.core.replica.TableType;
import com.hotels.bdp.circustrain.core.source.Source;
import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnpartitionedTableMetadataUpdateReplication
implements Replication {
    private static final Logger LOG = LoggerFactory.getLogger(UnpartitionedTableReplication.class);
    private final String database;
    private final String table;
    private final Source source;
    private final Replica replica;
    private final String eventId;
    private final String replicaDatabaseName;
    private final String replicaTableName;

    UnpartitionedTableMetadataUpdateReplication(String database, String table, Source source, Replica replica, EventIdFactory eventIdFactory, String replicaDatabaseName, String replicaTableName) {
        this.database = database;
        this.table = table;
        this.source = source;
        this.replica = replica;
        this.replicaDatabaseName = replicaDatabaseName;
        this.replicaTableName = replicaTableName;
        this.eventId = eventIdFactory.newEventId(EventIdPrefix.CIRCUS_TRAIN_UNPARTITIONED_TABLE.getPrefix());
    }

    public void replicate() throws CircusTrainException {
        try {
            this.replica.validateReplicaTable(this.replicaDatabaseName, this.replicaTableName);
            try (CloseableMetaStoreClient client = (CloseableMetaStoreClient)this.replica.getMetaStoreClientSupplier().get();){
                String previousLocation = this.getPreviousLocation(client);
                MetadataUpdateReplicaLocationManager replicaLocationManager = new MetadataUpdateReplicaLocationManager(client, TableType.UNPARTITIONED, previousLocation, this.replicaDatabaseName, this.replicaTableName);
                TableAndStatistics sourceTableAndStatistics = this.source.getTableAndStatistics(this.database, this.table);
                this.replica.updateMetadata(this.eventId, sourceTableAndStatistics, this.replicaDatabaseName, this.replicaTableName, replicaLocationManager);
            }
            LOG.info("Metadata updated for table {}.{} (no data copied).", (Object)this.database, (Object)this.table);
        }
        catch (Throwable t) {
            throw new CircusTrainException("Unable to replicate", t);
        }
    }

    private String getPreviousLocation(CloseableMetaStoreClient replicaClient) {
        Optional<Table> previousTable = this.replica.getTable(replicaClient, this.replicaDatabaseName, this.replicaTableName);
        if (!previousTable.isPresent()) {
            throw new InvalidReplicationModeException("Trying a " + ReplicationMode.METADATA_UPDATE.name() + " on a table that wasn't replicated before. This is not possible, rerun with a different table name or change the replication mode to " + ReplicationMode.FULL.name() + ".");
        }
        return ((Table)previousTable.get()).getSd().getLocation();
    }

    public String name() {
        return DotJoiner.join((String[])new String[]{this.database, this.table});
    }

    public String getEventId() {
        return this.eventId;
    }
}

