/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.conf;

import com.hotels.bdp.circustrain.core.conf.ExpressionParserFunctions;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class SpringExpressionParser {
    private final ExpressionParser parser = new SpelExpressionParser();
    private final StandardEvaluationContext evalContext = new StandardEvaluationContext();
    private final TemplateParserContext templateContext = new TemplateParserContext();

    SpringExpressionParser() {
        this(ExpressionParserFunctions.class);
    }

    SpringExpressionParser(Class<?> ... functionHolders) {
        for (Class<?> functionHolder : functionHolders) {
            for (Method method : ReflectionUtils.getAllDeclaredMethods(functionHolder)) {
                if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) continue;
                this.evalContext.registerFunction(method.getName(), method);
            }
        }
    }

    public String parse(String expressionString) {
        if (expressionString != null) {
            Expression expression = this.parser.parseExpression(expressionString, (ParserContext)this.templateContext);
            expressionString = expression.getValue((EvaluationContext)this.evalContext).toString();
        }
        return expressionString;
    }
}

