/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.data;

import com.hotels.bdp.circustrain.api.data.DataManipulatorFactory;
import com.hotels.bdp.circustrain.api.data.DataManipulatorFactoryManager;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Profile(value={"replication"})
@Component
@Order(value=0x7FFFFFFF)
public class DefaultDataManipulatorFactoryManager
implements DataManipulatorFactoryManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataManipulatorFactoryManager.class);
    static final String DATA_MANIPULATOR_FACTORY_CLASS = "data-manipulator-factory-class";
    private List<DataManipulatorFactory> dataManipulatorFactories;

    @Autowired
    public DefaultDataManipulatorFactoryManager(List<DataManipulatorFactory> factories) {
        this.dataManipulatorFactories = factories;
    }

    @PostConstruct
    void postConstruct() {
        log.debug("Initialized with {} DataManipulatorFactories", (Object)this.dataManipulatorFactories.size());
        for (DataManipulatorFactory factory : this.dataManipulatorFactories) {
            log.debug("DataManipulatorFactory class {}", (Object)factory.getClass().getName());
        }
    }

    public DataManipulatorFactory getFactory(Path sourceTableLocation, Path replicaTableLocation, Map<String, Object> copierOptions) {
        String replicaLocation = replicaTableLocation.toUri().getScheme();
        String sourceLocation = sourceTableLocation.toUri().getScheme();
        if (copierOptions.containsKey(DATA_MANIPULATOR_FACTORY_CLASS)) {
            for (DataManipulatorFactory factory : this.dataManipulatorFactories) {
                String factoryClassName = factory.getClass().getName();
                if (!factoryClassName.equals(copierOptions.get(DATA_MANIPULATOR_FACTORY_CLASS).toString())) continue;
                log.debug("Found DataManipulatorFactory '{}' using config", (Object)factoryClassName);
                return factory;
            }
        } else {
            for (DataManipulatorFactory factory : this.dataManipulatorFactories) {
                if (!factory.supportsSchemes(sourceLocation, replicaLocation)) continue;
                log.debug("Found DataManipulatorFactory {} for cleanup at location {}.", (Object)factory.getClass().getName(), (Object)replicaLocation);
                return factory;
            }
        }
        throw new UnsupportedOperationException("No DataManipulator found which can delete the data at location: " + replicaLocation);
    }
}

